/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import tech.jhipster.lite.module.domain.JHipsterModuleFactory;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleApiDoc;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleSlugFactory;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleTags;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModuleResource {
    private final JHipsterModuleSlug slug;
    private final JHipsterModulePropertiesDefinition propertiesDefinition;
    private final JHipsterModuleApiDoc apiDoc;
    private final JHipsterModuleOrganization organization;
    private final JHipsterModuleTags tags;
    private final JHipsterModuleFactory factory;

    private JHipsterModuleResource(JHipsterModuleResourceBuilder builder) {
        this.assertMandatoryFields(builder);
        this.slug = builder.slug.build();
        this.propertiesDefinition = builder.propertiesDefinition;
        this.apiDoc = builder.apiDoc;
        this.tags = builder.tags;
        this.organization = builder.organization;
        this.factory = builder.factory;
    }

    private void assertMandatoryFields(JHipsterModuleResourceBuilder builder) {
        Assert.notNull("slug", builder.slug);
        Assert.notNull("propertiesDefinition", builder.propertiesDefinition);
        Assert.notNull("apiDoc", builder.apiDoc);
        Assert.notNull("tags", builder.tags);
        Assert.notNull("organization", builder.organization);
        Assert.notNull("factory", builder.factory);
    }

    public static JHipsterModuleResourceSlugBuilder builder() {
        return new JHipsterModuleResourceBuilder();
    }

    public String moduleUrl() {
        return "/api/modules/" + this.slug.get();
    }

    public JHipsterModuleSlug slug() {
        return this.slug;
    }

    public JHipsterModuleApiDoc apiDoc() {
        return this.apiDoc;
    }

    public JHipsterModuleTags tags() {
        return this.tags;
    }

    public JHipsterModuleOrganization organization() {
        return this.organization;
    }

    public JHipsterModuleFactory factory() {
        return this.factory;
    }

    public JHipsterModulePropertiesDefinition propertiesDefinition() {
        return this.propertiesDefinition;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("slug", (Object)this.slug).append("apiDoc", (Object)this.apiDoc).append("tags", (Object)this.tags).append("organization", (Object)this.organization).append("propertiesDefinition", (Object)this.propertiesDefinition).build();
    }

    private static final class JHipsterModuleResourceBuilder
    implements JHipsterModuleResourceSlugBuilder,
    JHipsterModuleResourcePropertiesDefinitionBuilder,
    JHipsterModuleResourceApiDocBuilder,
    JHipsterModuleResourceOrganizationBuilder,
    JHipsterModuleResourceTagsBuilder,
    JHipsterModuleResourceFactoryBuilder {
        private JHipsterModuleSlugFactory slug;
        private JHipsterModuleApiDoc apiDoc;
        private JHipsterModuleFactory factory;
        private JHipsterModulePropertiesDefinition propertiesDefinition;
        private JHipsterModuleTags tags;
        private JHipsterModuleOrganization organization;

        private JHipsterModuleResourceBuilder() {
        }

        @Override
        public JHipsterModuleResourcePropertiesDefinitionBuilder slug(JHipsterModuleSlugFactory slug) {
            this.slug = slug;
            return this;
        }

        @Override
        public JHipsterModuleResourceApiDocBuilder propertiesDefinition(JHipsterModulePropertiesDefinition propertiesDefinition) {
            this.propertiesDefinition = propertiesDefinition;
            return this;
        }

        @Override
        public JHipsterModuleResourceOrganizationBuilder apiDoc(JHipsterModuleApiDoc apiDoc) {
            this.apiDoc = apiDoc;
            return this;
        }

        @Override
        public JHipsterModuleResourceTagsBuilder organization(JHipsterModuleOrganization organization) {
            this.organization = organization;
            return this;
        }

        @Override
        public JHipsterModuleResourceFactoryBuilder tags(JHipsterModuleTags tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public JHipsterModuleResource factory(JHipsterModuleFactory factory) {
            this.factory = factory;
            return new JHipsterModuleResource(this);
        }
    }

    public static interface JHipsterModuleResourceFactoryBuilder {
        public JHipsterModuleResource factory(JHipsterModuleFactory var1);
    }

    public static interface JHipsterModuleResourceTagsBuilder {
        public JHipsterModuleResourceFactoryBuilder tags(JHipsterModuleTags var1);

        default public JHipsterModuleResourceFactoryBuilder tags(String ... tags) {
            return this.tags(JHipsterModuleTags.builder().add(tags).build());
        }
    }

    public static interface JHipsterModuleResourceOrganizationBuilder {
        public JHipsterModuleResourceTagsBuilder organization(JHipsterModuleOrganization var1);

        default public JHipsterModuleResourceTagsBuilder standalone() {
            return this.organization(JHipsterModuleOrganization.STANDALONE);
        }
    }

    public static interface JHipsterModuleResourceApiDocBuilder {
        public JHipsterModuleResourceOrganizationBuilder apiDoc(JHipsterModuleApiDoc var1);

        default public JHipsterModuleResourceOrganizationBuilder apiDoc(String group, String operation) {
            return this.apiDoc(new JHipsterModuleApiDoc(group, operation));
        }
    }

    public static interface JHipsterModuleResourcePropertiesDefinitionBuilder {
        public JHipsterModuleResourceApiDocBuilder propertiesDefinition(JHipsterModulePropertiesDefinition var1);

        default public JHipsterModuleResourceApiDocBuilder withoutProperties() {
            return this.propertiesDefinition(JHipsterModulePropertiesDefinition.EMPTY);
        }
    }

    public static interface JHipsterModuleResourceSlugBuilder {
        public JHipsterModuleResourcePropertiesDefinitionBuilder slug(JHipsterModuleSlugFactory var1);
    }
}

