/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.file.TemplateRenderer;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.packagejson.JHipsterModulePackageJson;
import tech.jhipster.lite.module.domain.packagejson.NodeModuleFormat;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependencies;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependency;
import tech.jhipster.lite.module.domain.packagejson.PackageName;
import tech.jhipster.lite.module.domain.packagejson.PackageNames;
import tech.jhipster.lite.module.domain.packagejson.Scripts;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.MissingPackageJsonException;
import tech.jhipster.lite.shared.collection.domain.JHipsterCollections;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

@Service
class FileSystemPackageJsonHandler {
    private static final String QUOTE = "\"";
    private static final String LINE_END = ",";
    private static final String LINE_SEPARATOR = ",\n";
    private final NpmVersions npmVersions;
    private final TemplateRenderer templateRenderer;

    public FileSystemPackageJsonHandler(NpmVersions npmVersions, TemplateRenderer templateRenderer) {
        Assert.notNull("npmVersions", npmVersions);
        Assert.notNull("templateRenderer", templateRenderer);
        this.npmVersions = npmVersions;
        this.templateRenderer = templateRenderer;
    }

    public void handle(Indentation indentation, JHipsterProjectFolder projectFolder, JHipsterModulePackageJson packageJson, JHipsterModuleContext context) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("packageJson", packageJson);
        Assert.notNull("context", context);
        if (packageJson.isEmpty()) {
            return;
        }
        Path file = this.getPackageJsonFile(projectFolder);
        String content = this.readContent(file);
        content = this.replaceType(indentation, packageJson.nodeModuleFormat(), content);
        content = this.replaceScripts(indentation, packageJson.scripts(), content);
        content = this.replaceDevDependencies(indentation, packageJson.devDependencies(), content);
        content = this.replaceDependencies(indentation, packageJson.dependencies(), content);
        content = this.removeDependencies(indentation, packageJson.dependenciesToRemove(), content);
        content = this.removeDevDependencies(indentation, packageJson.devDependenciesToRemove(), content);
        content = this.replacePlaceholders(content, context);
        content = this.cleanupLineBreaks(indentation, content);
        this.write(file, content);
    }

    private Path getPackageJsonFile(JHipsterProjectFolder projectFolder) {
        Path file = projectFolder.filePath("package.json");
        if (Files.notExists(file, new LinkOption[0])) {
            throw new MissingPackageJsonException(projectFolder);
        }
        return file;
    }

    private String replacePlaceholders(String content, JHipsterModuleContext context) {
        return this.templateRenderer.render(content, context);
    }

    private String cleanupLineBreaks(Indentation indentation, String content) {
        return content.replaceAll(",(\\s*|[\r\n]*)}", "\n" + indentation.spaces() + "}");
    }

    private String replaceScripts(Indentation indentation, Scripts scripts, String content) {
        return JsonAction.replace().blockName("scripts").jsonContent(content).indentation(indentation).entries(this.scriptEntries(scripts)).apply();
    }

    private List<JsonEntry> scriptEntries(Scripts scripts) {
        return scripts.stream().map(script -> new JsonEntry(script.key().get(), script.command().get())).toList();
    }

    private String replaceDevDependencies(Indentation indentation, PackageJsonDependencies devDependencies, String content) {
        return JsonAction.replace().blockName("devDependencies").jsonContent(content).indentation(indentation).entries(this.dependenciesEntries(devDependencies)).apply();
    }

    private String removeDevDependencies(Indentation indentation, PackageNames dependenciesToRemove, String content) {
        return JsonAction.remove().blockName("devDependencies").jsonContent(content).indentation(indentation).entries(this.dependenciesEntries(dependenciesToRemove)).apply();
    }

    private String replaceDependencies(Indentation indentation, PackageJsonDependencies dependencies, String content) {
        return JsonAction.replace().blockName("dependencies").jsonContent(content).indentation(indentation).entries(this.dependenciesEntries(dependencies)).apply();
    }

    private String removeDependencies(Indentation indentation, PackageNames dependenciesToRemove, String content) {
        return JsonAction.remove().blockName("dependencies").jsonContent(content).indentation(indentation).entries(this.dependenciesEntries(dependenciesToRemove)).apply();
    }

    private String replaceType(Indentation indentation, Optional<NodeModuleFormat> nodeModuleFormat, String content) {
        if (nodeModuleFormat.isEmpty()) {
            return content;
        }
        return JsonAction.replace().blockName("type").jsonContent(content).indentation(indentation).blockValue(nodeModuleFormat.orElseThrow().name().toLowerCase(Locale.ROOT)).apply();
    }

    private List<JsonEntry> dependenciesEntries(PackageJsonDependencies dependencies) {
        return dependencies.stream().map(dependency -> new JsonEntry(dependency.packageName().get(), this.getNpmVersion((PackageJsonDependency)dependency))).toList();
    }

    private Collection<JsonEntry> dependenciesEntries(PackageNames packageNames) {
        return packageNames.stream().map(packageName -> new JsonEntry(packageName.get(), "")).toList();
    }

    private String getNpmVersion(PackageJsonDependency dependency) {
        PackageName packageName = dependency.versionPackageName().orElse(dependency.packageName());
        return this.npmVersions.get(packageName.get(), dependency.versionSource()).get();
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    private String readContent(Path file) {
        try {
            return Files.readString(file);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error reading " + String.valueOf(file.toAbsolutePath()) + " content" + e.getMessage(), e);
        }
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    private void write(Path file, String content) {
        try {
            Files.writeString(file, (CharSequence)content, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error writing " + String.valueOf(file.toAbsolutePath()) + ": " + e.getMessage(), e);
        }
    }

    private static final class JsonAction {
        private final String blockName;
        private final String jsonContent;
        private final Indentation indentation;
        private final Collection<JsonEntry> entries;
        private final JsonActionType action;
        private final String blockValue;

        private JsonAction(JsonActionBuilder builder) {
            Assert.notNull("action", (Object)builder.action);
            Assert.notNull("entries", builder.entries);
            this.blockName = builder.blockName;
            this.jsonContent = builder.jsonContent;
            this.indentation = builder.indentation;
            this.entries = builder.entries;
            this.action = builder.action;
            this.blockValue = builder.blockValue;
        }

        public static JsonActionBuilder replace() {
            return new JsonActionBuilder(JsonActionType.REPLACE);
        }

        public static JsonActionBuilder remove() {
            return new JsonActionBuilder(JsonActionType.REMOVE);
        }

        public String handle() {
            if (this.blockValue != null) {
                return this.appendNewRootEntry(this.jsonContent);
            }
            if (this.entries.isEmpty()) {
                return this.jsonContent;
            }
            return switch (this.action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.replaceEntries();
                case 1 -> this.removeEntries();
            };
        }

        private String replaceEntries() {
            String result = this.removeExistingEntries();
            Matcher blockMatcher = this.buildBlockMatcher(result);
            result = blockMatcher.find() ? this.appendEntries(blockMatcher) : this.appendNewBlock(result);
            return result;
        }

        private String removeEntries() {
            return this.removeExistingEntries();
        }

        private String appendEntries(Matcher blockMatcher) {
            return blockMatcher.replaceFirst(match -> {
                StringBuilder result = new StringBuilder().append(match.group(1)).append("\n");
                result.append(this.entriesBlock(this.indentation, this.entries));
                result.append(FileSystemPackageJsonHandler.LINE_END);
                return result.toString();
            });
        }

        private String appendNewRootEntry(String result) {
            String jsonBlock = FileSystemPackageJsonHandler.LINE_SEPARATOR + this.indentation.spaces() + FileSystemPackageJsonHandler.QUOTE + this.blockName + FileSystemPackageJsonHandler.QUOTE + ": " + FileSystemPackageJsonHandler.QUOTE + this.blockValue + FileSystemPackageJsonHandler.QUOTE;
            return result.replaceFirst("(\\s{1,10})}(\\s{1,10})$", jsonBlock + "$1}$2");
        }

        private String appendNewBlock(String result) {
            String jsonBlock = FileSystemPackageJsonHandler.LINE_SEPARATOR + this.indentation.spaces() + FileSystemPackageJsonHandler.QUOTE + this.blockName + FileSystemPackageJsonHandler.QUOTE + ": {" + "\n" + this.entriesBlock(this.indentation, this.entries) + "\n" + this.indentation.spaces() + "}";
            return result.replaceFirst("(\\s{1,10})}(\\s{1,10})$", jsonBlock + "$1}$2");
        }

        private Matcher buildBlockMatcher(String result) {
            return Pattern.compile("(\"" + this.blockName + "\"\\s*:\\s*\\{)").matcher(result);
        }

        @ExcludeFromGeneratedCodeCoverage(reason="Combiner can't be tested and an implementation detail")
        private String removeExistingEntries() {
            return this.entries.stream().map(this.toEntryPattern(this.blockName, this.indentation)).reduce(this.jsonContent, (json, entryPattern) -> entryPattern.matcher((CharSequence)json).replaceAll("$1$2"), (first, second) -> first);
        }

        private Function<JsonEntry, Pattern> toEntryPattern(String blockName, Indentation indentation) {
            return entry -> {
                String pattern = "(\"" + blockName + "\"\\s*:\\s*\\{)([^}]*)(\"" + entry.key() + "\"\\s*:\\s*\"[^\\r\\n]+[\\r\\n]{1,2}(\\s{" + indentation.spacesCount() * 2 + "})?)";
                return Pattern.compile(pattern, 32);
            };
        }

        private String entriesBlock(Indentation indentation, Collection<JsonEntry> entries) {
            return entries.stream().map(entry -> entry.toJson(indentation)).collect(Collectors.joining(FileSystemPackageJsonHandler.LINE_SEPARATOR));
        }

        private static final class JsonActionBuilder {
            private String blockName;
            private String jsonContent;
            private Indentation indentation;
            private Collection<JsonEntry> entries = List.of();
            private final JsonActionType action;
            private String blockValue;

            private JsonActionBuilder(JsonActionType action) {
                this.action = action;
            }

            private JsonActionBuilder blockName(String blockName) {
                this.blockName = blockName;
                return this;
            }

            private JsonActionBuilder jsonContent(String jsonContent) {
                this.jsonContent = jsonContent;
                return this;
            }

            private JsonActionBuilder indentation(Indentation indentation) {
                this.indentation = indentation;
                return this;
            }

            private JsonActionBuilder entries(Collection<JsonEntry> entries) {
                this.entries = JHipsterCollections.immutable(entries);
                return this;
            }

            private String apply() {
                return new JsonAction(this).handle();
            }

            public JsonActionBuilder blockValue(String blockValue) {
                this.blockValue = blockValue;
                return this;
            }
        }
    }

    private record JsonEntry(String key, String value) {
        String toJson(Indentation indentation) {
            return indentation.times(2) + FileSystemPackageJsonHandler.QUOTE + this.key() + FileSystemPackageJsonHandler.QUOTE + ": " + FileSystemPackageJsonHandler.QUOTE + this.value() + FileSystemPackageJsonHandler.QUOTE;
        }
    }

    private static enum JsonActionType {
        REPLACE,
        REMOVE;

    }
}

