/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.replacement.ContentReplacers;
import tech.jhipster.lite.module.domain.replacement.OptionalFileReplacer;
import tech.jhipster.lite.module.domain.replacement.OptionalReplacer;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.startupcommand.JHipsterStartupCommand;
import tech.jhipster.lite.module.domain.startupcommand.JHipsterStartupCommands;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

@Service
class FileSystemStartupCommandsReadmeCommandsHandler {
    private static final JHipsterProjectFilePath README = JHipsterModule.path("README.md");
    private static final TextNeedleBeforeReplacer JHIPSTER_STARTUP_COMMAND_SECTION_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-startupCommand -->");
    private static final String BASH_TEMPLATE = "```bash\n{{command}}\n```\n";
    private final FileSystemReplacer fileReplacer;

    public FileSystemStartupCommandsReadmeCommandsHandler(FileSystemReplacer fileReplacer) {
        this.fileReplacer = fileReplacer;
    }

    public void handle(JHipsterProjectFolder projectFolder, JHipsterStartupCommands commands, JHipsterModuleContext context) {
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("commands", commands);
        if (!commands.get().isEmpty()) {
            this.handleCommandsForProjectType(projectFolder, commands, context);
        }
    }

    private void handleCommandsForProjectType(JHipsterProjectFolder projectFolder, JHipsterStartupCommands commands, JHipsterModuleContext context) {
        commands.get().forEach(command -> this.addCommandToReadme(projectFolder, (JHipsterStartupCommand)command, context));
    }

    private void addCommandToReadme(JHipsterProjectFolder projectFolder, JHipsterStartupCommand command, JHipsterModuleContext context) {
        String replacedTemplate = BASH_TEMPLATE.replace("{{command}}", command.commandLine().get());
        OptionalReplacer replacer = new OptionalReplacer(JHIPSTER_STARTUP_COMMAND_SECTION_NEEDLE, replacedTemplate);
        this.fileReplacer.handle(projectFolder, ContentReplacers.of(new OptionalFileReplacer(README, replacer)), context);
    }
}

