/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.npm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.npm.NpmLazyInstaller;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.npm.NpmInstallException;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;
import tech.jhipster.lite.shared.npmdetector.infrastructure.secondary.NpmInstallationReader;
import tech.jhipster.lite.shared.npmdetector.infrastructure.secondary.NpmInstallationType;

@Service
@ExcludeFromGeneratedCodeCoverage(reason="Hard to test, requires npm installed")
class FileSystemNpmLazyInstaller
implements NpmLazyInstaller {
    private static final Logger log = LoggerFactory.getLogger(FileSystemNpmLazyInstaller.class);
    private final NpmInstallationReader npmInstallationReader = new NpmInstallationReader();

    FileSystemNpmLazyInstaller() {
    }

    @Override
    public void runInstallIn(JHipsterProjectFolder folder) {
        Assert.notNull("folder", folder);
        if (!folder.fileExists("package-lock.json")) {
            log.info("No package-lock.json found, npm install skipped");
            return;
        }
        NpmInstallationType npmInstallationType = this.npmInstallationReader.get();
        switch (npmInstallationType) {
            case UNIX: {
                this.execute(folder, "npm", "install");
                break;
            }
            case WINDOWS: {
                this.execute(folder, "npm.cmd", "install");
                break;
            }
            case NONE: {
                log.info("No npm installed, can't install npm dependencies");
            }
        }
    }

    private void execute(JHipsterProjectFolder path, String ... commands) {
        try {
            Process process = new ProcessBuilder(commands).directory(this.folderFile(path)).start();
            if (this.failedExecution(process)) {
                throw new NpmInstallException("Error during installation of npm dependencies, process failed");
            }
            this.traceProcess(String.join((CharSequence)" ", commands), process);
        }
        catch (IOException e) {
            throw new NpmInstallException("Error during installation of npm dependencies: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NpmInstallException("Error during installation of npm dependencies: " + e.getMessage(), e);
        }
    }

    private File folderFile(JHipsterProjectFolder path) {
        return new File(path.get());
    }

    private boolean failedExecution(Process process) throws InterruptedException {
        return !process.waitFor(1L, TimeUnit.MINUTES);
    }

    private void traceProcess(String command, Process process) throws IOException {
        String errors;
        if (log.isTraceEnabled()) {
            log.trace("{}: {}", (Object)command, (Object)this.read(process.getInputStream()));
        }
        if (StringUtils.isNotBlank((CharSequence)(errors = this.read(process.getErrorStream())))) {
            log.error("Error during {}: {}", (Object)command, (Object)errors);
        }
    }

    private String read(InputStream stream) throws IOException {
        return new String(stream.readAllBytes(), StandardCharsets.UTF_8).intern();
    }
}

