/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.statistic.domain.criteria;

import java.time.Instant;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.JHipsterSlug;

public final class StatisticsCriteria {
    private final Optional<Instant> startTime;
    private final Optional<Instant> endTime;
    private final Optional<JHipsterModuleSlug> moduleSlug;

    private StatisticsCriteria(StatisticsCriteriaBuilder builder) {
        this.startTime = Optional.ofNullable(builder.startTime);
        this.endTime = Optional.ofNullable(builder.endTime);
        this.moduleSlug = Optional.ofNullable(builder.moduleSlug).map(JHipsterModuleSlug::new);
    }

    public boolean isAnyCriteriaApplied() {
        return this.startTime.isPresent() || this.endTime.isPresent() || this.moduleSlug.isPresent();
    }

    public static StatisticsCriteriaBuilder builder() {
        return new StatisticsCriteriaBuilder();
    }

    public Optional<Instant> startTime() {
        return this.startTime;
    }

    public Optional<Instant> endTime() {
        return this.endTime;
    }

    public Optional<JHipsterModuleSlug> moduleSlug() {
        return this.moduleSlug;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("startTime", (Object)this.startTime.map(Instant::toString).orElse("")).append("endTime", (Object)this.endTime.map(Instant::toString).orElse("")).append("moduleSlug", (Object)this.moduleSlug.map(JHipsterSlug::get).orElse("")).toString();
    }

    public static class StatisticsCriteriaBuilder {
        private Instant startTime;
        private Instant endTime;
        private String moduleSlug;

        public StatisticsCriteriaBuilder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public StatisticsCriteriaBuilder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public StatisticsCriteriaBuilder moduleSlug(String moduleSlug) {
            this.moduleSlug = moduleSlug;
            return this;
        }

        public StatisticsCriteria build() {
            return new StatisticsCriteria(this);
        }
    }
}

