package tech.jhipster.lite.generator.ci.gitlab.domain;

import static tech.jhipster.lite.module.domain.JHipsterModule.from;
import static tech.jhipster.lite.module.domain.JHipsterModule.moduleBuilder;
import static tech.jhipster.lite.module.domain.JHipsterModule.to;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class GitLabCiModuleFactory {

  private static final JHipsterSource SOURCE = from("ci/gitlab");

  public JHipsterModule buildGitLabCiMavenModule(JHipsterModuleProperties properties) {
    Assert.notNull("properties", properties);

    return moduleBuilder(properties).files().add(SOURCE.template(".gitlab-ci-maven.yml.mustache"), to(".gitlab-ci.yml")).and().build();
  }

  public JHipsterModule buildGitLabCiGradleModule(JHipsterModuleProperties properties) {
    Assert.notNull("properties", properties);

    return moduleBuilder(properties).files().add(SOURCE.template(".gitlab-ci-gradle.yml.mustache"), to(".gitlab-ci.yml")).and().build();
  }
}
