/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.checkstyle.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CheckstyleModuleFactory {
    private static final JHipsterSource TEMPLATES_SOURCE = JHipsterModule.from("server/javatool/checkstyle/main");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(this.checkstyleMavenPlugin()).and().gradlePlugins().plugin(this.checkstyleGradlePlugin()).and().files().add(TEMPLATES_SOURCE.template("checkstyle.xml"), JHipsterModule.to("checkstyle.xml")).and().build();
    }

    private MavenPlugin checkstyleMavenPlugin() {
        return JHipsterModule.mavenPlugin().groupId("org.apache.maven.plugins").artifactId("maven-checkstyle-plugin").versionSlug("maven-checkstyle-plugin").configuration("<configLocation>checkstyle.xml</configLocation>\n<includeTestSourceDirectory>true</includeTestSourceDirectory>\n<consoleOutput>true</consoleOutput>\n<failsOnError>true</failsOnError>\n").addExecution(JHipsterModule.pluginExecution().goals("check").id("validate").phase(MavenBuildPhase.VALIDATE)).build();
    }

    private GradleMainBuildPlugin checkstyleGradlePlugin() {
        VersionSlug toolVersionSlug = new VersionSlug("checkstyle");
        return JHipsterModule.gradleCorePlugin().id("checkstyle").toolVersionSlug(toolVersionSlug).configuration("checkstyle {\n  configFile = rootProject.file(\"checkstyle.xml\")\n  toolVersion = libs.versions.%s.get()\n}\n".formatted(toolVersionSlug.slug())).build();
    }
}

