/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.okta.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class OAuth2OktaModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/security/oauth2/okta");
    private static final SpringProfile OKTA_SPRING_PROFILE = new SpringProfile("okta");
    private static final String OKTA_CLIENT_ID_PROPERTY = "oktaClientId";
    private static final String OKTA_DOMAIN_PROPERTY = "oktaDomain";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Okta"), SOURCE.template("documentation/okta.md")).files().add(SOURCE.file("okta.sh"), JHipsterModule.to("okta.sh")).add(SOURCE.file("documentation/images/security-add-claim.png"), JHipsterModule.to("documentation/images/security-add-claim.png")).and().springMainProperties(OKTA_SPRING_PROFILE).set(JHipsterModule.propertyKey("spring.security.oauth2.client.provider.oidc.issuer-uri"), OAuth2OktaModuleFactory.issuerUri(properties)).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.client-id"), OAuth2OktaModuleFactory.clientId(properties)).and().build();
    }

    private static PropertyValue issuerUri(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue("https://" + properties.getString(OKTA_DOMAIN_PROPERTY) + "/oauth2/default");
    }

    private static PropertyValue clientId(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue(properties.getString(OKTA_CLIENT_ID_PROPERTY));
    }
}

