/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.springcloud.configclient.domain;

import tech.jhipster.lite.generator.base64.domain.Base64Utils;
import tech.jhipster.lite.generator.server.springboot.springcloud.common.domain.SpringCloudModuleDependencies;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javaproperties.JHipsterModuleSpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SpringCloudConfigModuleFactory {
    private static final String JWT_BASE_64_SECRET = "jwtBase64Secret";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/springcloud/configclient");
    private static final PropertyValue FALSE_VALUE = JHipsterModule.propertyValue(false);
    private final DockerImages dockerImages;

    public SpringCloudConfigModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        PropertyValue baseNameValue = JHipsterModule.propertyValue(properties.projectBaseName().get());
        JHipsterModule.JHipsterModuleBuilder builder = this.initBuilder(properties);
        this.appendCommonProperties(builder.springMainBootstrapProperties(), baseNameValue);
        this.appendCommonProperties(builder.springMainBootstrapProperties(JHipsterModule.springProfile("local")), baseNameValue);
        return builder.springMainBootstrapProperties().set(JHipsterModule.propertyKey("spring.cloud.config.fail-fast"), JHipsterModule.propertyValue(true)).and().springMainBootstrapProperties(JHipsterModule.springProfile("local")).set(JHipsterModule.propertyKey("spring.cloud.config.fail-fast"), FALSE_VALUE).and().springTestBootstrapProperties().set(JHipsterModule.propertyKey("spring.application.name"), baseNameValue).set(JHipsterModule.propertyKey("spring.cloud.config.enabled"), FALSE_VALUE).and().build();
    }

    private JHipsterModule.JHipsterModuleBuilder initBuilder(JHipsterModuleProperties properties) {
        String jwtBase64secret = properties.getOrDefaultString(JWT_BASE_64_SECRET, Base64Utils.getBase64Secret());
        return JHipsterModule.moduleBuilder(properties).context().put("jhipsterRegistryDockerImage", this.dockerImages.get("jhipster/jhipster-registry").fullName()).put("base64JwtSecret", jwtBase64secret).and().javaDependencies().addDependencyManagement(SpringCloudModuleDependencies.springCloudDependenciesManagement()).addDependency(SpringCloudModuleDependencies.SPRING_CLOUD_GROUP, JHipsterModule.artifactId("spring-cloud-starter-bootstrap")).addDependency(SpringCloudModuleDependencies.SPRING_CLOUD_GROUP, JHipsterModule.artifactId("spring-cloud-starter-config")).and().files().add(SOURCE.template("jhipster-registry.yml"), JHipsterModule.toSrcMainDocker().append("jhipster-registry.yml")).add(SOURCE.template("application.config.properties"), JHipsterModule.toSrcMainDocker().append("central-server-config/localhost-config/application.properties")).and();
    }

    private void appendCommonProperties(JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder builder, PropertyValue baseNameValue) {
        builder.set(JHipsterModule.propertyKey("spring.application.name"), baseNameValue).set(JHipsterModule.propertyKey("jhipster.registry.password"), JHipsterModule.propertyValue("admin")).set(JHipsterModule.propertyKey("spring.cloud.compatibility-verifier.enabled"), FALSE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.config.label"), JHipsterModule.propertyValue("main")).set(JHipsterModule.propertyKey("spring.cloud.config.name"), baseNameValue).set(JHipsterModule.propertyKey("spring.cloud.config.retry.initial-interval"), JHipsterModule.propertyValue(1000)).set(JHipsterModule.propertyKey("spring.cloud.config.retry.max-attempts"), JHipsterModule.propertyValue(100)).set(JHipsterModule.propertyKey("spring.cloud.config.retry.max-interval"), JHipsterModule.propertyValue(2000)).set(JHipsterModule.propertyKey("spring.cloud.config.uri"), JHipsterModule.propertyValue("http://admin:${jhipster.registry.password}@localhost:8761/config"));
    }
}

