/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.DependencySlug;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.DependenciesCommandsFactory;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyClassifier;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.shared.collection.domain.JHipsterCollections;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public final class JavaDependency {
    private final DependencyId id;
    private final Optional<DependencySlug> dependencySlug;
    private final Optional<VersionSlug> versionSlug;
    private final JavaDependencyScope scope;
    private final boolean optional;
    private final Collection<DependencyId> exclusions;

    private JavaDependency(JavaDependencyBuilder builder) {
        this.id = this.buildId(builder);
        this.versionSlug = Optional.ofNullable(builder.versionSlug);
        this.dependencySlug = Optional.ofNullable(builder.dependencySlug);
        this.scope = JavaDependencyScope.from(builder.scope);
        this.optional = builder.optional;
        this.exclusions = JHipsterCollections.immutable(builder.exclusions);
    }

    private DependencyId buildId(JavaDependencyBuilder builder) {
        return DependencyId.builder().groupId(builder.groupId).artifactId(builder.artifactId).classifier(builder.classifier).type(builder.type).build();
    }

    public static JavaDependencyGroupIdBuilder builder() {
        return new JavaDependencyBuilder();
    }

    Collection<JavaBuildCommand> versionCommands(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies) {
        return this.version().flatMap(JavaDependency.toVersion(currentVersions, projectDependencies)).map(this.toSetVersionCommand()).map(List::of).orElse(List.of());
    }

    public static Function<VersionSlug, Optional<JavaDependencyVersion>> toVersion(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies) {
        return slug -> {
            JavaDependencyVersion currentVersion = currentVersions.get((VersionSlug)slug);
            return projectDependencies.version((VersionSlug)slug).map(JavaDependency.toVersionToUse(currentVersion)).orElseGet(() -> Optional.of(currentVersion));
        };
    }

    private static Function<JavaDependencyVersion, Optional<JavaDependencyVersion>> toVersionToUse(JavaDependencyVersion currentVersion) {
        return version -> {
            if (version.equals(currentVersion)) {
                return Optional.empty();
            }
            return Optional.of(currentVersion);
        };
    }

    private Function<JavaDependencyVersion, JavaBuildCommand> toSetVersionCommand() {
        return SetVersion::new;
    }

    Collection<JavaBuildCommand> dependencyCommands(DependenciesCommandsFactory commands, Optional<JavaDependency> projectDependency, Optional<BuildProfileId> buildProfile) {
        return projectDependency.map(this.toDependenciesCommands(commands, buildProfile)).orElseGet(() -> List.of(commands.addDependency(this, buildProfile)));
    }

    private Function<JavaDependency, Collection<JavaBuildCommand>> toDependenciesCommands(DependenciesCommandsFactory commands, Optional<BuildProfileId> buildProfile) {
        return projectDependency -> {
            JavaDependency resultingDependency = this.merge((JavaDependency)projectDependency);
            if (resultingDependency.equals(projectDependency)) {
                return List.of();
            }
            return List.of(commands.removeDependency(this.id(), buildProfile), commands.addDependency(resultingDependency, buildProfile));
        };
    }

    private JavaDependency merge(JavaDependency other) {
        return JavaDependency.builder().groupId(this.groupId()).artifactId(this.artifactId()).versionSlug(this.mergeVersionsSlugs(other)).dependencySlug(this.mergeDependencySlugs(other)).classifier((JavaDependencyClassifier)this.classifier().orElse(null)).scope(this.mergeScopes(other)).optional(this.mergeOptionalFlag(other)).type(this.type().orElse(null)).build();
    }

    private DependencySlug mergeDependencySlugs(JavaDependency other) {
        return this.dependencySlug.orElseGet(() -> other.dependencySlug.orElse(null));
    }

    private VersionSlug mergeVersionsSlugs(JavaDependency other) {
        return this.versionSlug.orElseGet(() -> other.versionSlug.orElse(null));
    }

    private JavaDependencyScope mergeScopes(JavaDependency other) {
        return this.scope.merge(other.scope);
    }

    private boolean mergeOptionalFlag(JavaDependency other) {
        return this.optional && other.optional;
    }

    public DependencyId id() {
        return this.id;
    }

    public Optional<VersionSlug> version() {
        return this.versionSlug;
    }

    public Optional<DependencySlug> slug() {
        return this.dependencySlug;
    }

    public Optional<JavaDependencyClassifier> classifier() {
        return this.id.classifier();
    }

    public boolean optional() {
        return this.optional;
    }

    public JavaDependencyScope scope() {
        return this.scope;
    }

    public Optional<JavaDependencyType> type() {
        return this.id.type();
    }

    public Collection<DependencyId> exclusions() {
        return this.exclusions;
    }

    private GroupId groupId() {
        return this.id.groupId();
    }

    private ArtifactId artifactId() {
        return this.id.artifactId();
    }

    @ExcludeFromGeneratedCodeCoverage
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.versionSlug).append((Object)this.scope).append(this.optional).hashCode();
    }

    @ExcludeFromGeneratedCodeCoverage
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaDependency other = (JavaDependency)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).append(this.dependencySlug, other.dependencySlug).append(this.versionSlug, other.versionSlug).append((Object)this.scope, (Object)other.scope).append(this.optional, other.optional).isEquals();
    }

    private static final class JavaDependencyBuilder
    implements JavaDependencyGroupIdBuilder,
    JavaDependencyArtifactIdBuilder,
    JavaDependencyOptionalValueBuilder {
        private GroupId groupId;
        private ArtifactId artifactId;
        private DependencySlug dependencySlug;
        private VersionSlug versionSlug;
        private JavaDependencyClassifier classifier;
        private JavaDependencyScope scope;
        private boolean optional;
        private JavaDependencyType type;
        private final Collection<DependencyId> exclusions = new ArrayList<DependencyId>();

        private JavaDependencyBuilder() {
        }

        @Override
        public JavaDependencyArtifactIdBuilder groupId(GroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder artifactId(ArtifactId artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder versionSlug(VersionSlug versionSlug) {
            this.versionSlug = versionSlug;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder dependencySlug(DependencySlug dependencySlug) {
            this.dependencySlug = dependencySlug;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder classifier(JavaDependencyClassifier classifier) {
            this.classifier = classifier;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder scope(JavaDependencyScope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder type(JavaDependencyType type) {
            this.type = type;
            return this;
        }

        @Override
        public JavaDependencyOptionalValueBuilder addExclusion(DependencyId dependency) {
            Assert.notNull("dependency", dependency);
            this.exclusions.add(dependency);
            return this;
        }

        @Override
        public JavaDependency build() {
            return new JavaDependency(this);
        }
    }

    public static interface JavaDependencyGroupIdBuilder {
        public JavaDependencyArtifactIdBuilder groupId(GroupId var1);

        default public JavaDependencyArtifactIdBuilder groupId(String groupId) {
            return this.groupId(new GroupId(groupId));
        }
    }

    public static interface JavaDependencyArtifactIdBuilder {
        public JavaDependencyOptionalValueBuilder artifactId(ArtifactId var1);

        default public JavaDependencyOptionalValueBuilder artifactId(String artifactId) {
            return this.artifactId(new ArtifactId(artifactId));
        }
    }

    public static interface JavaDependencyOptionalValueBuilder {
        public JavaDependencyOptionalValueBuilder versionSlug(VersionSlug var1);

        public JavaDependencyOptionalValueBuilder dependencySlug(DependencySlug var1);

        public JavaDependencyOptionalValueBuilder classifier(JavaDependencyClassifier var1);

        public JavaDependencyOptionalValueBuilder scope(JavaDependencyScope var1);

        public JavaDependencyOptionalValueBuilder optional(boolean var1);

        public JavaDependencyOptionalValueBuilder type(JavaDependencyType var1);

        public JavaDependencyOptionalValueBuilder addExclusion(DependencyId var1);

        public JavaDependency build();

        default public JavaDependencyOptionalValueBuilder dependencySlug(String dependencySlug) {
            return this.dependencySlug((DependencySlug)DependencySlug.of(dependencySlug).orElse(null));
        }

        default public JavaDependencyOptionalValueBuilder versionSlug(String versionSlug) {
            return this.versionSlug((VersionSlug)VersionSlug.of(versionSlug).orElse(null));
        }

        default public JavaDependencyOptionalValueBuilder classifier(String classifier) {
            return this.classifier((JavaDependencyClassifier)JavaDependencyClassifier.of(classifier).orElse(null));
        }

        default public JavaDependencyOptionalValueBuilder optional() {
            return this.optional(true);
        }

        default public JavaDependencyOptionalValueBuilder addExclusion(GroupId groupId, ArtifactId artifactId) {
            return this.addExclusion(DependencyId.of(groupId, artifactId));
        }
    }
}

