/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.shared.error.domain.Assert;

abstract class JavaDependencyCommandsCreator {
    private final JavaDependency dependency;

    JavaDependencyCommandsCreator(JavaDependency dependency) {
        Assert.notNull("dependency", dependency);
        this.dependency = dependency;
    }

    JavaBuildCommands changeCommands(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies, Optional<BuildProfileId> buildProfile) {
        Assert.notNull("currentVersion", currentVersions);
        Assert.notNull("projectDependencies", projectDependencies);
        Collection<JavaBuildCommand> versionCommands = this.dependency.versionCommands(currentVersions, projectDependencies);
        Collection<JavaBuildCommand> dependencyCommands = this.dependencyCommands(projectDependencies, buildProfile);
        return new JavaBuildCommands(Stream.of(versionCommands, dependencyCommands).flatMap(Collection::stream).toList());
    }

    protected JavaDependency dependency() {
        return this.dependency;
    }

    protected abstract Collection<JavaBuildCommand> dependencyCommands(ProjectJavaDependencies var1, Optional<BuildProfileId> var2);
}

