/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.landscape;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.JHipsterFeatureSlug;
import tech.jhipster.lite.module.domain.JHipsterSlug;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeDependencies;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeElement;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeModule;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterLandscapeFeature
implements JHipsterLandscapeElement {
    private final JHipsterFeatureSlug slug;
    private final Collection<JHipsterLandscapeModule> modules;
    private final Optional<JHipsterLandscapeDependencies> dependencies;

    public JHipsterLandscapeFeature(JHipsterFeatureSlug slug, Collection<JHipsterLandscapeModule> modules) {
        Assert.notNull("slug", slug);
        Assert.notNull("modules", modules);
        this.slug = slug;
        this.modules = modules;
        this.dependencies = this.buildDependencies();
    }

    private Optional<JHipsterLandscapeDependencies> buildDependencies() {
        return JHipsterLandscapeDependencies.of(this.modules().stream().map(JHipsterLandscapeModule::dependencies).filter(Optional::isPresent).map(Optional::get).flatMap(JHipsterLandscapeDependencies::stream).toList());
    }

    @Override
    public JHipsterFeatureSlug slug() {
        return this.slug;
    }

    public Collection<JHipsterLandscapeModule> modules() {
        return this.modules;
    }

    @Override
    public Optional<JHipsterLandscapeDependencies> dependencies() {
        return this.dependencies;
    }

    @Override
    public Stream<JHipsterLandscapeModule> allModules() {
        return this.modules.stream();
    }

    @Override
    public Stream<JHipsterSlug> slugs() {
        return Stream.concat(Stream.of(this.slug()), this.allModules().map(JHipsterLandscapeModule::slug));
    }
}

