/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.mavenplugin;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginConfiguration;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionGoal;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionId;
import tech.jhipster.lite.shared.collection.domain.JHipsterCollections;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public final class MavenPluginExecution {
    private final Collection<MavenPluginExecutionGoal> goals;
    private final Optional<MavenPluginExecutionId> id;
    private final Optional<MavenBuildPhase> phase;
    private final Optional<MavenPluginConfiguration> configuration;

    private MavenPluginExecution(MavenPluginExecutionBuilder builder) {
        Assert.notEmpty("goals", builder.goals);
        this.goals = JHipsterCollections.immutable(builder.goals);
        this.id = Optional.ofNullable(builder.id);
        this.phase = Optional.ofNullable(builder.phase);
        this.configuration = Optional.ofNullable(builder.configuration);
    }

    public static MavenPluginExecutionGoalsBuilder builder() {
        return new MavenPluginExecutionBuilder();
    }

    public Collection<MavenPluginExecutionGoal> goals() {
        return this.goals;
    }

    public Optional<MavenPluginExecutionId> id() {
        return this.id;
    }

    public Optional<MavenBuildPhase> phase() {
        return this.phase;
    }

    public Optional<MavenPluginConfiguration> configuration() {
        return this.configuration;
    }

    @ExcludeFromGeneratedCodeCoverage
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("goals", this.goals).append("id", (Object)this.id.map(MavenPluginExecutionId::toString).orElse("(empty)")).append("phase", (Object)this.phase.map(Enum::toString).orElse("(empty)")).append("configuration", (Object)this.configuration.map(MavenPluginConfiguration::toString).orElse("(empty)"));
        return builder.toString();
    }

    private static final class MavenPluginExecutionBuilder
    implements MavenPluginExecutionGoalsBuilder,
    MavenPluginExecutionOptionalBuilder {
        private MavenPluginExecutionId id;
        private MavenBuildPhase phase;
        private List<MavenPluginExecutionGoal> goals;
        private MavenPluginConfiguration configuration;

        private MavenPluginExecutionBuilder() {
        }

        @Override
        public MavenPluginExecutionOptionalBuilder goals(MavenPluginExecutionGoal ... goals) {
            this.goals = List.of(goals);
            return this;
        }

        @Override
        public MavenPluginExecutionOptionalBuilder phase(MavenBuildPhase phase) {
            this.phase = phase;
            return this;
        }

        @Override
        public MavenPluginExecutionOptionalBuilder id(MavenPluginExecutionId executionId) {
            this.id = executionId;
            return this;
        }

        @Override
        public MavenPluginExecutionOptionalBuilder configuration(MavenPluginConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public MavenPluginExecution build() {
            return new MavenPluginExecution(this);
        }
    }

    public static interface MavenPluginExecutionOptionalBuilder {
        public MavenPluginExecutionOptionalBuilder phase(MavenBuildPhase var1);

        public MavenPluginExecutionOptionalBuilder id(MavenPluginExecutionId var1);

        default public MavenPluginExecutionOptionalBuilder id(String executionId) {
            return this.id(new MavenPluginExecutionId(executionId));
        }

        public MavenPluginExecutionOptionalBuilder configuration(MavenPluginConfiguration var1);

        default public MavenPluginExecutionOptionalBuilder configuration(String configuration) {
            return this.configuration(new MavenPluginConfiguration(configuration));
        }

        public MavenPluginExecution build();
    }

    public static interface MavenPluginExecutionGoalsBuilder {
        public MavenPluginExecutionOptionalBuilder goals(MavenPluginExecutionGoal ... var1);

        default public MavenPluginExecutionOptionalBuilder goals(String ... goals) {
            return this.goals((MavenPluginExecutionGoal[])Stream.of(goals).map(MavenPluginExecutionGoal::new).toArray(MavenPluginExecutionGoal[]::new));
        }
    }
}

