/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.ProjectFiles;
import tech.jhipster.lite.module.domain.javabuild.JavaBuildTool;
import tech.jhipster.lite.module.domain.javabuild.ProjectJavaBuildToolRepository;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradleConfiguration;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.MissingJavaBuildConfigurationException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.GradleCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenCommandHandler;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

@Service
public class FileSystemJavaBuildCommandsHandler {
    private final ProjectJavaBuildToolRepository javaBuildTools;
    private final ProjectFiles filesReader;

    public FileSystemJavaBuildCommandsHandler(ProjectJavaBuildToolRepository javaBuildTools, ProjectFiles filesReader) {
        this.javaBuildTools = javaBuildTools;
        this.filesReader = filesReader;
    }

    public void handle(Indentation indentation, JHipsterProjectFolder projectFolder, JavaBuildCommands commands) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("commands", commands);
        if (commands.isEmpty()) {
            return;
        }
        JavaDependenciesCommandHandler handler = this.buildCommandHandler(indentation, projectFolder);
        commands.get().forEach(command -> this.handle(handler, (JavaBuildCommand)command));
    }

    private JavaDependenciesCommandHandler buildCommandHandler(Indentation indentation, JHipsterProjectFolder projectFolder) {
        JavaBuildTool javaBuildTool = this.javaBuildTools.detect(projectFolder).orElseThrow(() -> new MissingJavaBuildConfigurationException(projectFolder));
        return switch (javaBuildTool) {
            default -> throw new MatchException(null, null);
            case JavaBuildTool.MAVEN -> new MavenCommandHandler(indentation, projectFolder.filePath("pom.xml"));
            case JavaBuildTool.GRADLE -> new GradleCommandHandler(indentation, projectFolder, this.filesReader);
        };
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Jacoco thinks there is a missed branch")
    private void handle(JavaDependenciesCommandHandler handler, JavaBuildCommand command) {
        JavaBuildCommand javaBuildCommand = command;
        Objects.requireNonNull(javaBuildCommand);
        JavaBuildCommand javaBuildCommand2 = javaBuildCommand;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SetVersion.class, SetBuildProperty.class, RemoveJavaDependencyManagement.class, AddJavaDependencyManagement.class, RemoveDirectJavaDependency.class, AddDirectJavaDependency.class, AddDirectMavenPlugin.class, AddMavenPluginManagement.class, AddMavenBuildExtension.class, AddJavaBuildProfile.class, AddGradlePlugin.class, AddGradleConfiguration.class}, (Object)javaBuildCommand2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                SetVersion setVersion = (SetVersion)javaBuildCommand2;
                handler.handle(setVersion);
                break;
            }
            case 1: {
                SetBuildProperty setBuildProperty = (SetBuildProperty)javaBuildCommand2;
                handler.handle(setBuildProperty);
                break;
            }
            case 2: {
                RemoveJavaDependencyManagement removeJavaDependencyManagement = (RemoveJavaDependencyManagement)javaBuildCommand2;
                handler.handle(removeJavaDependencyManagement);
                break;
            }
            case 3: {
                AddJavaDependencyManagement addJavaDependencyManagement = (AddJavaDependencyManagement)javaBuildCommand2;
                handler.handle(addJavaDependencyManagement);
                break;
            }
            case 4: {
                RemoveDirectJavaDependency removeDirectJavaDependency = (RemoveDirectJavaDependency)javaBuildCommand2;
                handler.handle(removeDirectJavaDependency);
                break;
            }
            case 5: {
                AddDirectJavaDependency addDirectJavaDependency = (AddDirectJavaDependency)javaBuildCommand2;
                handler.handle(addDirectJavaDependency);
                break;
            }
            case 6: {
                AddDirectMavenPlugin addDirectMavenPlugin = (AddDirectMavenPlugin)javaBuildCommand2;
                handler.handle(addDirectMavenPlugin);
                break;
            }
            case 7: {
                AddMavenPluginManagement addMavenPluginManagement = (AddMavenPluginManagement)javaBuildCommand2;
                handler.handle(addMavenPluginManagement);
                break;
            }
            case 8: {
                AddMavenBuildExtension addMavenBuildExtension = (AddMavenBuildExtension)javaBuildCommand2;
                handler.handle(addMavenBuildExtension);
                break;
            }
            case 9: {
                AddJavaBuildProfile addJavaBuildProfile = (AddJavaBuildProfile)javaBuildCommand2;
                handler.handle(addJavaBuildProfile);
                break;
            }
            case 10: {
                AddGradlePlugin addGradlePlugin = (AddGradlePlugin)javaBuildCommand2;
                handler.handle(addGradlePlugin);
                break;
            }
            case 11: {
                AddGradleConfiguration addGradleConfiguration = (AddGradleConfiguration)javaBuildCommand2;
                handler.handle(addGradleConfiguration);
            }
        }
    }
}

