/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.error.domain;

import java.util.Map;
import tech.jhipster.lite.shared.error.domain.AssertionErrorType;
import tech.jhipster.lite.shared.error.domain.AssertionException;

public final class StringTooLongException
extends AssertionException {
    private final String maxLength;
    private final String currentLength;

    private StringTooLongException(StringTooLongExceptionBuilder builder) {
        super(builder.field, builder.message());
        this.maxLength = String.valueOf(builder.maxLength);
        this.currentLength = String.valueOf(builder.value.length());
    }

    public static StringTooLongExceptionBuilder builder() {
        return new StringTooLongExceptionBuilder();
    }

    @Override
    public AssertionErrorType type() {
        return AssertionErrorType.STRING_TOO_LONG;
    }

    @Override
    public Map<String, String> parameters() {
        return Map.of("maxLength", this.maxLength, "currentLength", this.currentLength);
    }

    public static final class StringTooLongExceptionBuilder {
        private String value;
        private int maxLength;
        private String field;

        private StringTooLongExceptionBuilder() {
        }

        StringTooLongExceptionBuilder field(String field) {
            this.field = field;
            return this;
        }

        StringTooLongExceptionBuilder value(String value) {
            this.value = value;
            return this;
        }

        StringTooLongExceptionBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        private String message() {
            return "The value in field \"" + this.field + "\" must be at most " + this.maxLength + " long but was " + this.value.length();
        }

        public StringTooLongException build() {
            return new StringTooLongException(this);
        }
    }
}

