/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Optional;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.CollectionStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.NodeEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.resolver.JsonScalarResolver;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;
import org.snakeyaml.engine.v2.scanner.StreamReader;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.BufferRecycler;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamReadContext;
import tools.jackson.dataformat.yaml.JacksonYAMLParseException;
import tools.jackson.dataformat.yaml.PackageVersion;
import tools.jackson.dataformat.yaml.YAMLReadFeature;

public class YAMLParser
extends ParserBase {
    protected final int _formatFeatures;
    protected final boolean _cfgEmptyStringsToNull;
    protected final Reader _reader;
    protected final ParserImpl _yamlParser;
    protected final ScalarResolver _yamlResolver = new JsonScalarResolver();
    protected SimpleStreamReadContext _streamReadContext;
    protected Event _lastEvent;
    protected Event _lastTagEvent;
    protected String _textValue;
    protected String _cleanedTextValue;
    protected String _currentName;
    protected boolean _currentIsAlias;
    protected Optional<Anchor> _currentAnchor;
    protected boolean _hasContent;
    protected boolean _emittingSyntheticEmptyObject;

    public YAMLParser(ObjectReadContext readCtxt, IOContext ioCtxt, BufferRecycler br, int streamReadFeatures, int formatFeatures, LoadSettings loadSettings, Reader reader) {
        this(readCtxt, ioCtxt, br, streamReadFeatures, formatFeatures, reader, YAMLParser._defaultParserImpl(loadSettings, reader));
    }

    protected YAMLParser(ObjectReadContext readCtxt, IOContext ioCtxt, BufferRecycler br, int streamReadFeatures, int formatFeatures, Reader reader, ParserImpl yamlParser) {
        super(readCtxt, ioCtxt, streamReadFeatures);
        this._formatFeatures = formatFeatures;
        this._reader = reader;
        this._yamlParser = yamlParser;
        this._cfgEmptyStringsToNull = YAMLReadFeature.EMPTY_STRING_AS_NULL.enabledIn(formatFeatures);
        DupDetector dups = StreamReadFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamReadFeatures) ? DupDetector.rootDetector((JsonParser)this) : null;
        this._streamReadContext = SimpleStreamReadContext.createRootContext((DupDetector)dups);
    }

    private static ParserImpl _defaultParserImpl(LoadSettings settings, Reader r) {
        if (settings == null) {
            settings = LoadSettings.builder().build();
        }
        return new ParserImpl(settings, new StreamReader(settings, r));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean isCurrentAlias() {
        return this._currentIsAlias;
    }

    public boolean canReadObjectId() {
        return true;
    }

    public boolean canReadTypeId() {
        return true;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    public Reader streamReadInputSource() {
        return this._reader;
    }

    protected void _closeInput() throws IOException {
        if (this._reader != null && (this._ioContext.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE))) {
            this._reader.close();
        }
    }

    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public boolean isEnabled(YAMLReadFeature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public TokenStreamLocation currentTokenLocation() {
        if (this._lastEvent == null) {
            return TokenStreamLocation.NA;
        }
        return this._locationFor(this._lastEvent.getStartMark());
    }

    public TokenStreamLocation currentLocation() {
        if (this._lastEvent == null) {
            return TokenStreamLocation.NA;
        }
        return this._locationFor(this._lastEvent.getEndMark());
    }

    protected TokenStreamLocation _locationFor(Optional<Mark> option) {
        if (!option.isPresent()) {
            return new TokenStreamLocation(this._ioContext.contentReference(), -1L, -1, -1);
        }
        Mark m = option.get();
        return new TokenStreamLocation(this._ioContext.contentReference(), (long)m.getIndex(), m.getLine() + 1, m.getColumn() + 1);
    }

    public JsonToken nextToken() throws JacksonException {
        this._currentIsAlias = false;
        this._binaryValue = null;
        this._numTypesValid = 0;
        if (this._closed) {
            return null;
        }
        if (this._emittingSyntheticEmptyObject) {
            this._emittingSyntheticEmptyObject = false;
            this._streamReadContext = this._streamReadContext.getParent();
            JsonToken token = this._updateToken(JsonToken.END_OBJECT);
            this.close();
            return token;
        }
        block16: while (true) {
            Event evt;
            try {
                evt = this.nextEvent();
            }
            catch (YamlEngineException e) {
                throw new JacksonYAMLParseException((JsonParser)this, e.getMessage(), (Exception)((Object)e));
            }
            catch (NumberFormatException e) {
                throw this._constructReadException(String.format("Malformed Number token: failed to tokenize due to (%s): %s", e.getClass().getName(), e.getMessage()), e);
            }
            if (evt == null) {
                this._currentAnchor = Optional.empty();
                this._lastTagEvent = null;
                return this._updateTokenToNull();
            }
            this._lastEvent = evt;
            if (this._streamReadContext.inObject()) {
                if (this._currToken != JsonToken.PROPERTY_NAME) {
                    String name;
                    if (evt.getEventId() != Event.ID.Scalar) {
                        this._currentAnchor = Optional.empty();
                        this._lastTagEvent = null;
                        if (evt.getEventId() == Event.ID.MappingEnd) {
                            if (!this._streamReadContext.inObject()) {
                                this._reportMismatchedEndMarker(125, ']');
                            }
                            this._streamReadContext = this._streamReadContext.getParent();
                            return this._updateToken(JsonToken.END_OBJECT);
                        }
                        this._reportError("Expected a property name (Scalar value in YAML), got this instead: " + String.valueOf(evt));
                    }
                    ScalarEvent scalar = (ScalarEvent)evt;
                    boolean firstEntry = this._currToken == JsonToken.START_OBJECT;
                    Optional newAnchor = scalar.getAnchor();
                    if (newAnchor.isPresent() || !firstEntry) {
                        this._currentAnchor = scalar.getAnchor();
                    }
                    if (!firstEntry) {
                        this._lastTagEvent = evt;
                    }
                    this._currentName = name = scalar.getValue();
                    this._streamReadContext.setCurrentName(name);
                    return this._updateToken(JsonToken.PROPERTY_NAME);
                }
            } else if (this._streamReadContext.inArray()) {
                this._streamReadContext.valueRead();
            }
            this._currentAnchor = Optional.empty();
            this._lastTagEvent = evt;
            switch (evt.getEventId()) {
                case Scalar: {
                    this._hasContent = true;
                    JsonToken t = this._decodeScalar((ScalarEvent)evt);
                    return this._updateToken(t);
                }
                case MappingStart: {
                    this._hasContent = true;
                    Optional m = evt.getStartMark();
                    MappingStartEvent map = (MappingStartEvent)evt;
                    this._currentAnchor = map.getAnchor();
                    this._streamReadContext = this._streamReadContext.createChildObjectContext(m.map(mark -> mark.getLine()).orElse(0).intValue(), m.map(mark -> mark.getColumn()).orElse(0).intValue());
                    this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
                    return this._updateToken(JsonToken.START_OBJECT);
                }
                case MappingEnd: {
                    this._reportError("Not expecting END_OBJECT but a value");
                }
                case SequenceStart: {
                    this._hasContent = true;
                    Optional mrk = evt.getStartMark();
                    this._currentAnchor = ((NodeEvent)evt).getAnchor();
                    this._streamReadContext = this._streamReadContext.createChildArrayContext(mrk.map(mark -> mark.getLine()).orElse(0).intValue(), mrk.map(mark -> mark.getColumn()).orElse(0).intValue());
                    this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
                    return this._updateToken(JsonToken.START_ARRAY);
                }
                case SequenceEnd: {
                    if (!this._streamReadContext.inArray()) {
                        this._reportMismatchedEndMarker(93, '}');
                    }
                    this._streamReadContext = this._streamReadContext.getParent();
                    return this._updateToken(JsonToken.END_ARRAY);
                }
                case DocumentEnd: {
                    continue block16;
                }
                case DocumentStart: {
                    continue block16;
                }
                case Alias: {
                    AliasEvent alias = (AliasEvent)evt;
                    this._currentIsAlias = true;
                    this._textValue = ((Anchor)alias.getAnchor().orElseThrow(() -> new RuntimeException("Alias must be provided."))).getValue();
                    this._cleanedTextValue = null;
                    return this._updateToken(JsonToken.VALUE_STRING);
                }
                case StreamEnd: {
                    if (!this._hasContent && YAMLReadFeature.EMPTY_DOCUMENT_AS_EMPTY_OBJECT.enabledIn(this._formatFeatures)) {
                        this._emittingSyntheticEmptyObject = true;
                        this._streamReadContext.createChildObjectContext(0, 0);
                        return this._updateToken(JsonToken.START_OBJECT);
                    }
                    this.close();
                    return this._updateTokenToNull();
                }
                case StreamStart: {
                    continue block16;
                }
                case Comment: {
                    continue block16;
                }
            }
        }
    }

    protected Event nextEvent() {
        return this._yamlParser.next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonToken _decodeScalar(ScalarEvent scalar) throws JacksonException {
        String value;
        this._textValue = value = scalar.getValue();
        this._cleanedTextValue = null;
        if (!this._cfgEmptyStringsToNull && value.isEmpty()) {
            return JsonToken.VALUE_STRING;
        }
        Optional typeTagOptional = scalar.getTag();
        int len = value.length();
        if (!typeTagOptional.isPresent() || ((String)typeTagOptional.get()).equals("!")) {
            Tag nodeTag = this._yamlResolver.resolve(value, Boolean.valueOf(scalar.getImplicit().canOmitTagInPlainScalar()));
            if (nodeTag == Tag.STR) {
                return JsonToken.VALUE_STRING;
            }
            if (nodeTag == Tag.INT) {
                return this._decodeNumberScalar(value, len);
            }
            if (nodeTag == Tag.FLOAT) {
                this._numTypesValid = 0;
                return this._cleanYamlFloat(value);
            }
            if (nodeTag == Tag.BOOL) {
                Boolean B = this._matchYAMLBoolean(value, len);
                if (B == null) return JsonToken.VALUE_STRING;
                return B != false ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            if (nodeTag != Tag.NULL) return JsonToken.VALUE_STRING;
            return JsonToken.VALUE_NULL;
        }
        String typeTag = (String)typeTagOptional.get();
        if (typeTag.startsWith("tag:yaml.org,2002:") && (typeTag = typeTag.substring("tag:yaml.org,2002:".length())).contains(",")) {
            String[] tags = typeTag.split(",");
            String string = typeTag = tags.length == 0 ? "" : tags[0];
        }
        if ("binary".equals(typeTag)) {
            value = value.trim();
            try {
                this._binaryValue = Base64Variants.MIME.decode(value);
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            catch (IllegalArgumentException e) {
                this._reportError(e.getMessage());
            }
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if ("bool".equals(typeTag)) {
            Boolean B = this._matchYAMLBoolean(value, len);
            if (B == null) return JsonToken.VALUE_STRING;
            return B != false ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }
        if (len <= 0) return JsonToken.VALUE_STRING;
        if ("int".equals(typeTag)) {
            return this._decodeNumberScalar(value, len);
        }
        if ("float".equals(typeTag)) {
            this._numTypesValid = 0;
            return this._cleanYamlFloat(value);
        }
        if (!"null".equals(typeTag)) return JsonToken.VALUE_STRING;
        return JsonToken.VALUE_NULL;
    }

    protected Boolean _matchYAMLBoolean(String value, int len) {
        switch (len) {
            case 4: {
                if (!"true".equalsIgnoreCase(value)) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (!"false".equalsIgnoreCase(value)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected JsonToken _decodeNumberScalar(String value, int len) throws JacksonException {
        block15: {
            int i;
            char ch = value.charAt(0);
            if (ch == '-') {
                this._numberNegative = true;
                i = 1;
            } else if (ch == '+') {
                this._numberNegative = false;
                if (len == 1) {
                    return null;
                }
                i = 1;
            } else {
                this._numberNegative = false;
                i = 0;
            }
            if (len == i) {
                return null;
            }
            if (value.charAt(i) == '0') {
                if (++i == len) {
                    this._numberInt = 0;
                    this._numTypesValid = 1;
                    return JsonToken.VALUE_NUMBER_INT;
                }
                ch = value.charAt(i);
                switch (ch) {
                    case 'B': 
                    case 'b': {
                        return this._decodeNumberIntBinary(value, i + 1, len, this._numberNegative);
                    }
                    case 'X': 
                    case 'x': {
                        return this._decodeNumberIntHex(value, i + 1, len, this._numberNegative);
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case '_': {
                        return this._decodeNumberIntOctal(value, i, len, this._numberNegative);
                    }
                }
                return JsonToken.VALUE_STRING;
            }
            boolean underscores = false;
            do {
                char c;
                if ((c = value.charAt(i)) <= '9' && c >= '0') continue;
                if (c != '_') break block15;
                underscores = true;
            } while (++i != len);
            this._numTypesValid = 0;
            if (underscores) {
                return this._cleanYamlInt(value);
            }
            this._cleanedTextValue = this._textValue;
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _decodeNumberIntBinary(String value, int i, int origLen, boolean negative) throws JacksonException {
        String cleansed = this._cleanUnderscores(value, i, origLen);
        int digitLen = cleansed.length();
        if (digitLen <= 31) {
            int v = this._decodeInt(cleansed, 2);
            if (negative) {
                v = -v;
            }
            this._numberInt = v;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (digitLen <= 63) {
            return this._decodeFromLong(this._decodeLong(cleansed, 2), negative, digitLen == 32);
        }
        return this._decodeFromBigInteger(this._decodeBigInt(cleansed, 2), negative);
    }

    protected JsonToken _decodeNumberIntOctal(String value, int i, int origLen, boolean negative) throws JacksonException {
        String cleansed = this._cleanUnderscores(value, i, origLen);
        int digitLen = cleansed.length();
        if (digitLen <= 10) {
            int v = this._decodeInt(cleansed, 8);
            if (negative) {
                v = -v;
            }
            this._numberInt = v;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (digitLen <= 21) {
            return this._decodeFromLong(this._decodeLong(cleansed, 8), negative, false);
        }
        return this._decodeFromBigInteger(this._decodeBigInt(cleansed, 8), negative);
    }

    protected JsonToken _decodeNumberIntHex(String value, int i, int origLen, boolean negative) throws JacksonException {
        String cleansed = this._cleanUnderscores(value, i, origLen);
        int digitLen = cleansed.length();
        if (digitLen <= 7) {
            int v = this._decodeInt(cleansed, 16);
            if (negative) {
                v = -v;
            }
            this._numberInt = v;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (digitLen <= 15) {
            return this._decodeFromLong(this._decodeLong(cleansed, 16), negative, digitLen == 8);
        }
        return this._decodeFromBigInteger(this._decodeBigInt(cleansed, 16), negative);
    }

    private JsonToken _decodeFromLong(long unsignedValue, boolean negative, boolean checkIfInt) {
        long actualValue;
        if (negative) {
            actualValue = -unsignedValue;
            if (checkIfInt && actualValue >= Integer.MIN_VALUE) {
                this._numberInt = (int)actualValue;
                this._numTypesValid = 1;
                return JsonToken.VALUE_NUMBER_INT;
            }
        } else {
            if (checkIfInt && unsignedValue < Integer.MAX_VALUE) {
                this._numberInt = (int)unsignedValue;
                this._numTypesValid = 1;
                return JsonToken.VALUE_NUMBER_INT;
            }
            actualValue = unsignedValue;
        }
        this._numberLong = actualValue;
        this._numTypesValid = 2;
        return JsonToken.VALUE_NUMBER_INT;
    }

    private JsonToken _decodeFromBigInteger(BigInteger unsignedValue, boolean negative) {
        this._numberBigInt = negative ? unsignedValue.negate() : unsignedValue;
        this._numTypesValid = 4;
        return JsonToken.VALUE_NUMBER_INT;
    }

    private int _decodeInt(String numStr, int base) throws JacksonException {
        try {
            return Integer.parseInt(numStr, base);
        }
        catch (NumberFormatException e) {
            return (Integer)this._reportInvalidNumber(numStr, base, e);
        }
    }

    private long _decodeLong(String numStr, int base) throws JacksonException {
        try {
            return Long.parseLong(numStr, base);
        }
        catch (NumberFormatException e) {
            return (Long)this._reportInvalidNumber(numStr, base, e);
        }
    }

    private BigInteger _decodeBigInt(String numStr, int base) throws JacksonException {
        try {
            return base == 10 ? NumberInput.parseBigInteger((String)numStr, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER)) : NumberInput.parseBigIntegerWithRadix((String)numStr, (int)base, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException e) {
            return (BigInteger)this._reportInvalidNumber(numStr, base, e);
        }
    }

    private <T> T _reportInvalidNumber(String numStr, int base, Exception e) throws JacksonException {
        this._reportError(String.format("Invalid base-%d number ('%s'), problem: %s", base, numStr, e.getMessage()));
        return null;
    }

    public boolean hasStringCharacters() {
        return false;
    }

    public String getString() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textValue;
        }
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._currentName;
        }
        if (this._currToken != null) {
            if (this._currToken.isScalarValue()) {
                return this._textValue;
            }
            return this._currToken.asString();
        }
        return null;
    }

    public String currentName() throws JacksonException {
        SimpleStreamReadContext parent;
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._currentName;
        }
        if ((this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) && (parent = this._streamReadContext.getParent()) != null) {
            return parent.currentName();
        }
        return this._streamReadContext.currentName();
    }

    public char[] getStringCharacters() throws JacksonException {
        String text = this.getString();
        return text == null ? null : text.toCharArray();
    }

    public int getStringLength() throws JacksonException {
        String text = this.getString();
        return text == null ? 0 : text.length();
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public int getString(Writer writer) throws JacksonException {
        String str = this.getString();
        if (str == null) {
            return 0;
        }
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return str.length();
    }

    public Object getEmbeddedObject() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws JacksonException {
        byte[] b = this.getBinaryValue(b64variant);
        try {
            out.write(b);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return b.length;
    }

    public Object getNumberValueDeferred() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            if (this._cleanedTextValue == null) {
                this._reportError("Internal number decoding error: `_cleanedTextValue` null when nothing decoded for `JsonToken.VALUE_NUMBER_INT`");
            }
            return this._cleanedTextValue;
        }
        if (this._currToken != JsonToken.VALUE_NUMBER_FLOAT) {
            this._reportError("Current token (" + String.valueOf(this._currToken) + ") not numeric, can not use numeric value accessors");
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 8) != 0) {
            return this._getNumberDouble();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        return this._cleanedTextValue;
    }

    protected void _parseNumericValue(int expType) throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int len = this._cleanedTextValue.length();
            if (this._numberNegative) {
                --len;
            }
            if (len <= 9) {
                this._numberInt = this._decodeInt(this._cleanedTextValue, 10);
                this._numTypesValid = 1;
                return;
            }
            if (len <= 18) {
                long l = Long.parseLong(this._cleanedTextValue);
                if (len == 10) {
                    if (this._numberNegative) {
                        if (l >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                return;
            }
            String numStr = this._cleanedTextValue;
            try {
                this.streamReadConstraints().validateIntegerLength(numStr.length());
                BigInteger n = NumberInput.parseBigInteger((String)numStr, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                if (len == 19 && n.bitLength() <= 63) {
                    this._numberLong = n.longValue();
                    this._numTypesValid = 2;
                    return;
                }
                this._numberBigInt = n;
                this._numTypesValid = 4;
                return;
            }
            catch (NumberFormatException nex) {
                throw this._constructReadException(String.format("Malformed numeric value '%s: (%s) %s", this._textValue, nex.getClass().getName(), nex.getMessage()));
            }
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            String numStr = this._cleanedTextValue;
            try {
                this.streamReadConstraints().validateFPLength(numStr.length());
                if (expType == 16) {
                    this._numberBigDecimal = NumberInput.parseBigDecimal((String)numStr, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    this._numTypesValid = 16;
                } else {
                    this.streamReadConstraints().validateFPLength(numStr.length());
                    this._numberDouble = NumberInput.parseDouble((String)numStr, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                    this._numTypesValid = 8;
                }
            }
            catch (NumberFormatException nex) {
                throw this._constructReadException(String.format("Malformed numeric value '%s: (%s) %s", this._textValue, nex.getClass().getName(), nex.getMessage()));
            }
            return;
        }
        this._reportError("Current token (" + String.valueOf(this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    protected int _parseIntValue() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int len = this._cleanedTextValue.length();
            if (this._numberNegative) {
                --len;
            }
            if (len <= 9) {
                this._numberInt = this._decodeInt(this._cleanedTextValue, 10);
                this._numTypesValid = 1;
                return this._numberInt;
            }
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    public String getObjectId() throws JacksonException {
        return this._currentAnchor.map(a -> a.getValue()).orElse(null);
    }

    public String getTypeId() throws JacksonException {
        Optional tagOpt;
        if (this._lastTagEvent instanceof CollectionStartEvent) {
            tagOpt = ((CollectionStartEvent)this._lastTagEvent).getTag();
        } else if (this._lastTagEvent instanceof ScalarEvent) {
            tagOpt = ((ScalarEvent)this._lastTagEvent).getTag();
        } else {
            return null;
        }
        if (tagOpt.isPresent()) {
            String tag = (String)tagOpt.get();
            while (tag.startsWith("!")) {
                tag = tag.substring(1);
            }
            return tag;
        }
        return null;
    }

    private JsonToken _cleanYamlInt(String str) throws JacksonException {
        int i;
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        int n = i = str.charAt(0) == '+' ? 1 : 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c != '_') {
                sb.append(c);
            }
            ++i;
        }
        this._cleanedTextValue = sb.toString();
        if (this._cleanedTextValue.isEmpty() || "-".equals(this._cleanedTextValue)) {
            this._reportError(String.format("Invalid number ('%s')", str));
        }
        return JsonToken.VALUE_NUMBER_INT;
    }

    private String _cleanUnderscores(String str, int i, int len) {
        StringBuilder sb = new StringBuilder(len);
        while (i < len) {
            char ch = str.charAt(i);
            if (ch != '_') {
                sb.append(ch);
            }
            ++i;
        }
        if (sb.length() == len) {
            return str;
        }
        return sb.toString();
    }

    private JsonToken _cleanYamlFloat(String str) {
        int i;
        int len = str.length();
        int ix = str.indexOf(95);
        if (ix < 0 || len == 0) {
            this._cleanedTextValue = str;
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        StringBuilder sb = new StringBuilder(len);
        int n = i = str.charAt(0) == '+' ? 1 : 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c != '_') {
                sb.append(c);
            }
            ++i;
        }
        this._cleanedTextValue = sb.toString();
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    protected void _reportMismatchedEndMarker(int actCh, char expCh) throws JacksonException {
        TokenStreamContext ctxt = this.streamReadContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)actCh), Character.valueOf(expCh), ctxt.typeDesc(), ctxt.startLocation(this._contentReference())));
    }
}

