/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jakarta.rs.json;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.jakarta.rs.base.ProviderBase;
import tools.jackson.jakarta.rs.cfg.MapperConfiguratorBase;
import tools.jackson.jakarta.rs.json.JsonEndpointConfig;
import tools.jackson.jakarta.rs.json.JsonMapperConfigurator;
import tools.jackson.jakarta.rs.json.PackageVersion;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/json", "text/json", "*/*"})
public class JacksonJsonProvider
extends ProviderBase<JacksonJsonProvider, JsonMapper, JsonEndpointConfig, JsonMapperConfigurator> {
    public static final String MIME_JAVASCRIPT = "application/javascript";
    public static final String MIME_JAVASCRIPT_MS = "application/x-javascript";
    protected String _jsonpFunctionName;
    @Context
    protected Providers _providers;

    public JacksonJsonProvider() {
        this(null, null);
    }

    public JacksonJsonProvider(JsonMapper mapper) {
        this(mapper, null);
    }

    public JacksonJsonProvider(JsonMapper mapper, AnnotationIntrospector aiOverride) {
        super((MapperConfiguratorBase)new JsonMapperConfigurator(mapper, aiOverride));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setJSONPFunctionName(String fname) {
        this._jsonpFunctionName = fname;
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json") || "javascript".equals(subtype) || "x-javascript".equals(subtype) || "x-json".equals(subtype);
        }
        return true;
    }

    protected JsonMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        JsonMapper m = (JsonMapper)((JsonMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (m == null) {
            if (this._providers != null) {
                ContextResolver resolver = this._providers.getContextResolver(JsonMapper.class, mediaType);
                if (resolver == null) {
                    resolver = this._providers.getContextResolver(JsonMapper.class, null);
                }
                if (resolver != null) {
                    return (JsonMapper)resolver.getContext(type);
                }
            }
            if (m == null) {
                m = (JsonMapper)((JsonMapperConfigurator)this._mapperConfig).getDefaultMapper();
            }
        }
        return m;
    }

    protected JsonEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return JsonEndpointConfig.forReading(reader, annotations);
    }

    protected JsonEndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return JsonEndpointConfig.forWriting(writer, annotations, this._jsonpFunctionName);
    }
}

