/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific;

import com.fasterxml.jackson.databind.JsonNode;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.condition.NumberCondition;
import uk.org.webcompere.modelassert.json.condition.PredicateWrappedCondition;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;

public interface NumberComparisonDsl<A>
extends Satisfies<A> {
    default public A satisfiesNumberCondition(Condition condition) {
        return this.satisfies(new PredicateWrappedCondition("Number", JsonNode::isNumber, condition));
    }

    default public A isGreaterThan(Number number) {
        return this.satisfiesNumberCondition(new NumberCondition<Number>(number, NumberCondition.Comparison.GREATER_THAN));
    }

    default public A isGreaterThanOrEqualTo(Number number) {
        return this.satisfiesNumberCondition(new NumberCondition<Number>(number, NumberCondition.Comparison.GREATER_THAN_OR_EQUAL));
    }

    default public A isLessThan(Number number) {
        return this.satisfiesNumberCondition(new NumberCondition<Number>(number, NumberCondition.Comparison.LESS_THAN));
    }

    default public A isLessThanOrEqualTo(Number number) {
        return this.satisfiesNumberCondition(new NumberCondition<Number>(number, NumberCondition.Comparison.LESS_THAN_OR_EQUAL));
    }

    default public A isBetween(Number firstInclusive, Number lastInclusive) {
        return this.satisfiesNumberCondition(new NumberCondition<Number>(firstInclusive, NumberCondition.Comparison.GREATER_THAN_OR_EQUAL).and(new NumberCondition<Number>(lastInclusive, NumberCondition.Comparison.LESS_THAN_OR_EQUAL)));
    }

    default public A isZero() {
        return this.satisfiesNumberCondition(new NumberCondition<Integer>(0, NumberCondition.Comparison.EQUAL_TO));
    }
}

