/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific.tree;

import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import uk.org.webcompere.modelassert.json.condition.Not;
import uk.org.webcompere.modelassert.json.condition.tree.PathRule;
import uk.org.webcompere.modelassert.json.condition.tree.TreeComparisonCondition;
import uk.org.webcompere.modelassert.json.condition.tree.TreeRule;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.tree.IsEqualToDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.tree.PathDsl;

public class WhereDsl<A>
implements IsEqualToDsl<A> {
    private Satisfies<A> coreAssertion;
    private List<PathRule> rules = new LinkedList<PathRule>();

    public WhereDsl(Satisfies<A> coreAssertion) {
        this.coreAssertion = coreAssertion;
    }

    public WhereDsl<A> keysInAnyOrder() {
        return this.pathRule(new PathRule(TreeRule.IGNORE_KEY_ORDER));
    }

    public WhereDsl<A> objectContains() {
        return this.pathRule(new PathRule(TreeRule.OBJECT_CONTAINS));
    }

    public WhereDsl<A> arrayInAnyOrder() {
        return this.pathRule(new PathRule(TreeRule.IGNORE_ARRAY_ORDER));
    }

    public WhereDsl<A> arrayContains() {
        return this.pathRule(new PathRule(TreeRule.ARRAY_CONTAINS));
    }

    public WhereDsl<A> configuredBy(UnaryOperator<WhereDsl<A>> configurer) {
        return (WhereDsl)configurer.apply(this);
    }

    WhereDsl<A> pathRule(PathRule pathRule) {
        this.rules.add(pathRule);
        return this;
    }

    public PathDsl<A> path(Object pathStart, Object ... pathRemainder) {
        return new PathDsl(this, pathStart, pathRemainder);
    }

    public PathDsl<A> at(String jsonPointer) {
        return PathDsl.fromJsonPointer(this, jsonPointer);
    }

    @Override
    public A isEqualTo(TreeComparisonCondition condition) {
        return this.coreAssertion.satisfies(condition.withRules(this.rules));
    }

    @Override
    public A isNotEqualTo(TreeComparisonCondition condition) {
        return this.coreAssertion.satisfies(Not.not(condition.withRules(this.rules)));
    }
}

