/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.JsonProvider;
import uk.org.webcompere.modelassert.json.Result;
import uk.org.webcompere.modelassert.json.condition.JsonIsNotNull;
import uk.org.webcompere.modelassert.json.dsl.JsonNodeAssertDsl;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;

public abstract class CoreJsonAssertion<T, A extends CoreJsonAssertion<T, A>>
extends BaseMatcher<T>
implements JsonNodeAssertDsl<A>,
Satisfies<A> {
    private JsonProvider<T> jsonProvider;
    private List<Condition> conditions = new LinkedList<Condition>();

    protected CoreJsonAssertion(JsonProvider<T> jsonProvider) {
        this.jsonProvider = jsonProvider;
        this.conditions.add(new JsonIsNotNull());
    }

    @Override
    public A satisfies(Condition condition) {
        this.conditions.add(condition);
        return this.assertion();
    }

    A assertion() {
        return (A)this;
    }

    public boolean matches(Object item) {
        JsonNode jsonNode = this.jsonProvider.jsonFrom(item);
        return this.conditions.stream().map(condition -> condition.test(jsonNode)).allMatch(Result::isPassed);
    }

    public void describeTo(Description description) {
        description.appendText(this.conditions.stream().map(Condition::describe).collect(Collectors.joining("\n")));
    }

    public void describeMismatch(Object item, Description description) {
        JsonNode jsonNode = this.jsonProvider.jsonFrom(item);
        description.appendText(this.conditions.stream().map(condition -> condition.test(jsonNode)).filter(res -> !res.isPassed()).map(res -> res.getCondition() + " was " + res.getWas()).collect(Collectors.joining("\n")));
    }

    public ArgumentMatcher<T> toArgumentMatcher() {
        return this::matches;
    }
}

