/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import ws.schild.jave.filters.Filter;

public class MediaConcatFilter
extends Filter {
    public MediaConcatFilter(int nSources) {
        super("concat");
        this.initFilter(nSources, true, true);
    }

    public MediaConcatFilter(int nSources, boolean concatVideo, boolean concatAudio) {
        super("concat");
        this.initFilter(nSources, concatVideo, concatAudio);
    }

    protected void initFilter(int nSources, boolean concatVideo, boolean concatAudio) {
        String destinationDescription = "";
        if (concatVideo && concatAudio) {
            destinationDescription = "v=1:a=1";
        } else if (concatVideo) {
            destinationDescription = "v=1:a=0";
        } else if (concatAudio) {
            destinationDescription = "v=0:a=1";
        }
        this.initFilter(nSources, concatVideo, concatAudio, destinationDescription);
    }

    protected void initFilter(int nSources, boolean concatVideo, boolean concatAudio, String destinationDescription) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nSources; ++i) {
            if (i > 0) {
                sb.append("] [");
            }
            sb.append(Integer.toString(i));
            if (concatVideo) {
                sb.append(":v:0");
                if (!concatAudio) continue;
                sb.append("] [").append(Integer.toString(i)).append(":a:0");
                continue;
            }
            if (!concatAudio) continue;
            sb.append(":a:0");
        }
        this.addInputLabel(sb.toString());
        this.addNamedArgument("n", Integer.toString(nSources) + ":" + destinationDescription);
    }
}

