/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.GradientDrawable;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BitmapUtils {
    private static final int JPEG_COMPRESSION_QUALITY = 70;
    private static final String TAG = BitmapUtils.class.getSimpleName();

    BitmapUtils() {
    }

    public static GradientDrawable getRoundedRectangleShape(Context context, int color, boolean isSelected) {
        GradientDrawable shape = new GradientDrawable();
        float cornerRadius = 30.0f;
        if (isSelected) {
            shape.setShape(0);
            int radius = (int)(cornerRadius * context.getResources().getDisplayMetrics().density);
            shape.setCornerRadius((float)radius);
            shape.setColor(color);
        } else {
            shape.setColor(0);
        }
        return shape;
    }

    static String compressedImageFromBitmap(Bitmap bitmap, String fileName) {
        try {
            File file = BitmapUtils.createTempFile(fileName);
            if (file == null) {
                return null;
            }
            Log.i((String)TAG, (String)file.getAbsolutePath());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)bos);
            byte[] bitmapData = bos.toByteArray();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bitmapData);
            fileOutputStream.flush();
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File createTempFile(String fileName) {
        try {
            File file;
            File folder = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/pinaki_camera");
            folder.mkdirs();
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                fileName = "tmp_img123.jpeg";
            }
            if ((file = new File(folder, fileName)).exists()) {
                file.delete();
            }
            if (file.createNewFile()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static Bitmap createSampledBitmapFromBytes(byte[] jpegByteArray, int maxDimensionSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])jpegByteArray, (int)0, (int)jpegByteArray.length, (BitmapFactory.Options)options);
        Log.i((String)"CAMERA-Bitmap", (String)("Original width, height: " + options.outWidth + ", " + options.outHeight));
        double aspectRatio = (double)options.outWidth * 1.0 / (double)options.outHeight;
        int targetWidth = 0;
        int targetHeight = 0;
        if (options.outWidth > options.outHeight) {
            targetWidth = maxDimensionSize;
            targetHeight = (int)((double)targetWidth / aspectRatio);
        } else {
            targetHeight = maxDimensionSize;
            targetWidth = (int)((double)targetHeight * aspectRatio);
        }
        Log.i((String)"CAMERA-Bitmap", (String)("target width, height: " + targetWidth + ", " + targetHeight));
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        Log.i((String)"CAMERA-Bitmap", (String)("sample size: " + options.inSampleSize));
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])jpegByteArray, (int)0, (int)jpegByteArray.length, (BitmapFactory.Options)options);
        Log.i((String)"CAMERA-Bitmap", (String)("Changed width, height: " + options.outWidth + ", " + options.outHeight));
        return bitmap;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

