/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import xyz.pinaki.android.camera.CameraFragment;

public class CameraController {
    private static String TAG = CameraController.class.getSimpleName();
    private final boolean shouldFixOrientation = true;

    private CameraController() {
    }

    public static CameraController getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void launch(AppCompatActivity activity, int containerID) {
        if (CameraController.isCamera2Supported((Context)activity)) {
            Log.i((String)TAG, (String)"Camera2 Supported");
        } else {
            Log.i((String)TAG, (String)"Camera2 NOT Supported");
        }
        int orientation = activity.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            activity.setRequestedOrientation(1);
        } else {
            activity.setRequestedOrientation(0);
        }
        activity.getSupportFragmentManager().beginTransaction().replace(containerID, (Fragment)CameraFragment.newInstance(), "CameraFragment").commit();
    }

    private static boolean isCamera2Supported(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            if (cameraManager.getCameraIdList().length == 0) {
                return false;
            }
            for (String cameraIdStr : cameraManager.getCameraIdList()) {
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraIdStr);
                Integer hardwareSupport = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (hardwareSupport == null) {
                    return false;
                }
                if (hardwareSupport != 2 && hardwareSupport != 0) continue;
                return false;
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static class SingletonHolder {
        private static final CameraController INSTANCE = new CameraController();

        private SingletonHolder() {
        }
    }
}

