/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import java.util.List;
import xyz.pinaki.android.camera.CameraCallback;
import xyz.pinaki.android.camera.CameraFlashMode;
import xyz.pinaki.android.camera.CameraHandlerThread;
import xyz.pinaki.android.camera.CenteredCameraPreviewHolder;
import xyz.pinaki.android.camera.DeviceOrientationListener;
import xyz.pinaki.android.camera.RotationEventListener;
import xyz.pinaki.androidcamera.R;

public class CameraFragment
extends Fragment {
    private static final int COMPRESS_IMAGE_MAX_DIMENSION = 800;
    private static final String TAG = CameraFragment.class.getSimpleName();
    private static final int REQUEST_CAMERA = 0;
    private Camera camera = null;
    private DeviceOrientationListener orientationListener;
    private RotationEventListener rotationEventListener = new RotationEventListener();
    private int cameraId = 1;
    private boolean shouldCreateLowresImage = true;
    CenteredCameraPreviewHolder previewHolder;
    RelativeLayout parentLayout;
    View previewContainer;
    ImageView previewImage;
    private CameraHandlerThread cameraHandlerThread;
    private final CameraCallback cameraCallback = new CameraCallback(){

        @Override
        public void onPictureTaken(Bitmap bitmap) {
            CameraFragment.this.cameraHandlerThread.processBitmap(CameraFragment.this.cameraId, bitmap, CameraFragment.this.orientationListener, CameraFragment.this.rotationEventListener, this);
        }

        @Override
        public void onCameraOpen(Camera cam) {
            CameraFragment.this.camera = cam;
            CameraFragment.this.previewHolder = CameraFragment.this.createCenteredCameraPreview((Activity)CameraFragment.this.getActivity());
            CameraFragment.this.previewHolder.addSurfaceView();
            CameraFragment.this.parentLayout.addView((View)CameraFragment.this.previewHolder, 0);
            CameraFragment.this.previewHolder.setCamera(CameraFragment.this.camera, CameraFragment.this.cameraId);
        }

        @Override
        public void onBitmapProcessed(Bitmap bitmap) {
            CameraFragment.this.previewContainer.setVisibility(0);
            CameraFragment.this.previewImage.setImageBitmap(bitmap);
            CameraFragment.this.previewHolder.startCameraPreview();
        }
    };

    public static CameraFragment newInstance() {
        return new CameraFragment();
    }

    private static boolean checkCameraHardware(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public void takePicture() {
        if (this.previewHolder != null) {
            Log.i((String)TAG, (String)("safeToTakePicture: " + this.previewHolder.getSafeToTakePicture()));
            this.orientationListener.rememberOrientation();
            if (this.previewHolder.getSafeToTakePicture()) {
                this.previewHolder.setSafeToTakePicture(false);
                this.cameraHandlerThread.capturePhoto(this.camera, this.cameraCallback);
            }
        } else {
            Log.i((String)TAG, (String)"previewHolder is NULL");
        }
    }

    public void onResume() {
        super.onResume();
        this.cameraHandlerThread = new CameraHandlerThread();
        this.cameraHandlerThread.start();
        this.openCamera();
        this.orientationListener.enable();
    }

    private void openCamera() {
        if (ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA") != 0) {
            this.requestCameraPermission();
        } else if (CameraFragment.checkCameraHardware(this.getContext())) {
            try {
                if (this.camera != null) {
                    this.stopAndRelease();
                }
                this.cameraHandlerThread.openCamera(this.cameraId, this.cameraCallback);
            }
            catch (RuntimeException exception) {
                Log.i((String)TAG, (String)("Cannot open camera with id " + this.cameraId), (Throwable)exception);
            }
        } else {
            Log.i((String)TAG, (String)"Camera Not Present");
        }
    }

    private void stopAndRelease() {
        if (this.previewHolder != null) {
            this.previewHolder.stopCameraPreview();
            this.previewHolder.unsetCamera();
        }
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
    }

    public void onPause() {
        Log.i((String)TAG, (String)"onPause");
        super.onPause();
        this.stopAndRelease();
        this.orientationListener.disable();
        if (this.cameraHandlerThread != null) {
            this.cameraHandlerThread.quit();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        Log.i((String)TAG, (String)"onActivityCreated");
        super.onActivityCreated(savedInstanceState);
        if (this.getActivity() instanceof AppCompatActivity && ((AppCompatActivity)this.getActivity()).getSupportActionBar() != null) {
            ((AppCompatActivity)this.getActivity()).getSupportActionBar().hide();
        } else if (this.getActivity() != null && this.getActivity().getActionBar() != null) {
            this.getActivity().getActionBar().hide();
        }
        this.orientationListener = new DeviceOrientationListener((Context)this.getActivity());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Log.i((String)TAG, (String)"onCreateView");
        this.parentLayout = (RelativeLayout)inflater.inflate(R.layout.camera_fragment, container, false);
        if (ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA") != 0) {
            Log.i((String)TAG, (String)"Requesting Camera Permissions from onCreateView ");
            this.requestCameraPermission();
        }
        return this.parentLayout;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        View shutterIcon = view.findViewById(R.id.shutter);
        shutterIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraFragment.this.takePicture();
            }
        });
        View cameraSwitch = view.findViewById(R.id.switch_cam);
        cameraSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraFragment.this.stopAndRelease();
                CameraFragment.this.switchCamera();
            }
        });
        this.previewContainer = view.findViewById(R.id.preview_container);
        this.previewImage = (ImageView)view.findViewById(R.id.preview_image);
        ImageView previewCloseButton = (ImageView)view.findViewById(R.id.preview_close_icon);
        previewCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraFragment.this.previewContainer.setVisibility(4);
            }
        });
    }

    public void onDestroyView() {
        Log.i((String)TAG, (String)"onDestroyView");
        super.onDestroyView();
    }

    private CenteredCameraPreviewHolder createCenteredCameraPreview(Activity activity) {
        CenteredCameraPreviewHolder previewHolder = new CenteredCameraPreviewHolder(activity, this.rotationEventListener);
        previewHolder.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        previewHolder.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return previewHolder;
    }

    void switchCamera() {
        this.cameraId = this.cameraId == 0 ? 1 : 0;
        Log.i((String)TAG, (String)("switching to camera: " + this.cameraId));
        this.parentLayout.removeView((View)this.previewHolder);
        this.openCamera();
    }

    protected boolean hasFlash() {
        Camera.Parameters params = this.camera.getParameters();
        List flashModes = params.getSupportedFlashModes();
        if (flashModes == null) {
            return false;
        }
        for (String flashMode : flashModes) {
            if (!"on".equals(flashMode)) continue;
            return true;
        }
        return false;
    }

    protected void setFlashMode(CameraFlashMode mode) {
        if (this.camera == null || !this.hasFlash()) {
            return;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        switch (mode) {
            case AUTO: {
                parameters.setFlashMode("auto");
                break;
            }
            case OFF: {
                parameters.setFlashMode("off");
                break;
            }
            case ON: {
                parameters.setFlashMode("on");
                break;
            }
            default: {
                parameters.setFlashMode("off");
            }
        }
        this.camera.setParameters(parameters);
    }

    private void requestCameraPermission() {
        if (!this.shouldShowRequestPermissionRationale("android.permission.CAMERA")) {
            this.requestPermissions(new String[]{"android.permission.CAMERA"}, 0);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Log.i((String)TAG, (String)"onReq permissions result");
        if (requestCode == 0) {
            Log.i((String)TAG, (String)"Received response for Camera permission request.");
            if (grantResults.length == 1 && grantResults[0] == 0) {
                Log.i((String)TAG, (String)"CAMERA permission has now been granted. Showing preview.");
            } else {
                Log.i((String)TAG, (String)"CAMERA permission was NOT granted.");
            }
        }
    }
}

