/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import xyz.pinaki.android.camera.BitmapUtils;
import xyz.pinaki.android.camera.CameraCallback;
import xyz.pinaki.android.camera.DeviceOrientationListener;
import xyz.pinaki.android.camera.RotationEventListener;

class CameraHandlerThread
extends HandlerThread {
    private static final String TAG = CameraHandlerThread.class.getSimpleName();
    private Handler workerHandler = null;

    CameraHandlerThread() {
        super(TAG);
    }

    void openCamera(final int cameraId, final CameraCallback cameraCallback) {
        if (this.workerHandler == null) {
            this.workerHandler = new Handler(this.getLooper());
        }
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    final Camera camera = Camera.open((int)cameraId);
                    Handler uiHandler = new Handler(Looper.getMainLooper());
                    uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            cameraCallback.onCameraOpen(camera);
                        }
                    });
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)"Failed to Open Camera");
                    e.printStackTrace();
                }
            }
        });
    }

    void capturePhoto(final Camera camera, final CameraCallback cameraCallback) {
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                camera.takePicture(null, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] bytes, Camera camera) {
                        final Bitmap bitmap = BitmapUtils.createSampledBitmapFromBytes(bytes, 800);
                        Handler uiHandler = new Handler(Looper.getMainLooper());
                        uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (cameraCallback != null) {
                                    cameraCallback.onPictureTaken(bitmap);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    void processBitmap(final int cameraId, final Bitmap bitmap, final DeviceOrientationListener orientationListener, final RotationEventListener rotationEventListener, final CameraCallback cameraCallback) {
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                Matrix matrix = new Matrix();
                if (cameraId == 1) {
                    float[] mirrorY = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                    Matrix matrixMirrorY = new Matrix();
                    matrixMirrorY.setValues(mirrorY);
                    matrix.postConcat(matrixMirrorY);
                }
                int rotation = rotationEventListener.getCameraDisplayRotation();
                rotation = (rotation + orientationListener.getRememberedOrientation() + rotationEventListener.getDeviceDisplayRotation()) % 360;
                matrix.postRotate((float)rotation);
                final Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
                bitmap.recycle();
                Handler uiHandler = new Handler(Looper.getMainLooper());
                uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (cameraCallback != null) {
                            cameraCallback.onBitmapProcessed(rotatedBitmap);
                        }
                    }
                });
            }
        });
    }
}

