/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import java.io.IOException;
import java.util.List;
import xyz.pinaki.android.camera.RotationEventListener;

class CenteredCameraPreviewHolder
extends ViewGroup
implements SurfaceHolder.Callback {
    private final String TAG = CenteredCameraPreviewHolder.class.getSimpleName();
    SurfaceView surfaceView;
    Camera.Size previewSize;
    Camera.Size pictureSize;
    Camera camera;
    Activity activity;
    int cameraId = 0;
    RotationEventListener rotationEventListener;
    private boolean safeToTakePicture = false;

    public CenteredCameraPreviewHolder(Context context) {
        super(context);
    }

    CenteredCameraPreviewHolder(Activity activity, RotationEventListener rListener) {
        super((Context)activity);
        this.activity = activity;
        this.rotationEventListener = rListener;
    }

    void addSurfaceView() {
        Log.i((String)this.TAG, (String)"addSurfaceView");
        if (this.surfaceView != null) {
            this.removeView((View)this.surfaceView);
            this.surfaceView = null;
        }
        this.surfaceView = new SurfaceView((Context)this.activity);
        this.addView((View)this.surfaceView);
        SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        surfaceHolder.setType(3);
    }

    void unsetCamera() {
        this.camera = null;
        this.cameraId = 0;
    }

    void setCamera(Camera camera, int cameraId) {
        this.camera = camera;
        this.cameraId = cameraId;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CenteredCameraPreviewHolder.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CenteredCameraPreviewHolder.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        if (this.camera != null) {
            try {
                Camera.Parameters parameters = this.camera.getParameters();
                List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
                List supportedPictureSize = parameters.getSupportedPictureSizes();
                this.previewSize = this.getOptimalPreviewSize(supportedPreviewSizes, width, height);
                this.pictureSize = this.getOptimalPreviewSize(supportedPictureSize, width, height);
            }
            catch (RuntimeException exception) {
                Log.i((String)this.TAG, (String)"RuntimeException caused by getParameters in onMeasure", (Throwable)exception);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (changed && this.getChildCount() > 0) {
            float factW;
            float factH;
            View child = this.getChildAt(0);
            int availableWidth = r - l;
            int availableHeight = b - t;
            int previewWidth = availableWidth;
            int previewHeight = availableHeight;
            if (this.previewSize != null) {
                if (this.isPortrait()) {
                    previewWidth = this.previewSize.height;
                    previewHeight = this.previewSize.width;
                } else {
                    previewWidth = this.previewSize.width;
                    previewHeight = this.previewSize.height;
                }
            }
            float fact = (factH = (float)availableHeight / (float)previewHeight) < (factW = (float)availableWidth / (float)previewWidth) ? factH : factW;
            int layoutHeight = (int)((float)previewHeight * fact);
            int layoutWidth = (int)((float)previewWidth * fact);
            child.layout((availableWidth - layoutWidth) / 2, (availableHeight - layoutHeight) / 2, (availableWidth + layoutWidth) / 2, (availableHeight + layoutHeight) / 2);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.i((String)this.TAG, (String)"surfaceCreated");
        try {
            if (this.camera != null) {
                this.camera.setPreviewDisplay(holder);
            }
        }
        catch (IOException exception) {
            Log.i((String)this.TAG, (String)"IOException caused by setPreviewDisplay()", (Throwable)exception);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.i((String)this.TAG, (String)"surfaceDestroyed");
        if (this.camera != null) {
            this.stopCameraPreview();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)this.TAG, (String)"surfaceChanged");
        if (this.camera != null) {
            Log.i((String)this.TAG, (String)("surfaceChanged " + this.previewSize.width + ", " + this.previewSize.height + "|| " + this.pictureSize.width + ", " + this.pictureSize.height));
            try {
                Camera.Parameters parameters = this.camera.getParameters();
                if (this.previewSize != null) {
                    parameters.setPreviewSize(this.previewSize.width, this.previewSize.height);
                }
                if (this.pictureSize != null) {
                    parameters.setPictureSize(this.pictureSize.width, this.pictureSize.height);
                }
                this.camera.setParameters(parameters);
                this.configureOrientationParams();
                this.requestLayout();
                this.startCameraPreview();
            }
            catch (RuntimeException exception) {
                Log.i((String)this.TAG, (String)"RuntimeException caused by getParameters in surfaceChanged", (Throwable)exception);
            }
        }
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int targetWidth, int targetHeight) {
        int previewHeight;
        int previewWidth;
        double ASPECT_TOLERANCE = 0.01;
        double targetRatio = (double)targetWidth / (double)targetHeight;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        boolean isPortrait = this.isPortrait();
        for (Camera.Size size : sizes) {
            double ratio;
            previewWidth = size.width;
            previewHeight = size.height;
            if (isPortrait) {
                previewWidth = size.height;
                previewHeight = size.width;
            }
            if (Math.abs((ratio = (double)previewWidth / (double)previewHeight) - targetRatio) > 0.01 || !((double)Math.abs(previewHeight - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(previewHeight - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                double curRatio;
                double deltaRatio;
                previewWidth = size.width;
                previewHeight = size.height;
                if (isPortrait) {
                    previewWidth = size.height;
                    previewHeight = size.width;
                }
                if (!((deltaRatio = Math.abs(targetRatio - (curRatio = (double)previewWidth / (double)previewHeight))) < minDiff)) continue;
                optimalSize = size;
                minDiff = deltaRatio;
            }
        }
        return optimalSize;
    }

    void startCameraPreview() {
        Log.i((String)this.TAG, (String)"startCameraPreview");
        if (this.camera != null) {
            Log.i((String)this.TAG, (String)"startCameraPreview in If Block");
            this.camera.startPreview();
            this.safeToTakePicture = true;
        }
    }

    void stopCameraPreview() {
        if (this.camera != null) {
            this.camera.stopPreview();
        }
    }

    private boolean isPortrait() {
        return this.activity.getResources().getConfiguration().orientation == 1;
    }

    private void configureOrientationParams() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)cameraInfo);
        this.rotationEventListener.onRotationChanged(this.activity, cameraInfo);
        this.camera.setDisplayOrientation(this.rotationEventListener.getCameraDisplayRotation());
    }

    final boolean getSafeToTakePicture() {
        return this.safeToTakePicture;
    }

    void setSafeToTakePicture(boolean safeToTakePicture) {
        this.safeToTakePicture = safeToTakePicture;
    }
}

