/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.content.Context;
import android.view.OrientationEventListener;

class DeviceOrientationListener
extends OrientationEventListener {
    private int currentNormalizedOrientation = 0;
    private int rememberedNormalizedOrientation = 0;

    DeviceOrientationListener(Context context) {
        super(context, 3);
    }

    public void onOrientationChanged(int orientation) {
        if (orientation != -1) {
            this.currentNormalizedOrientation = this.normalize(orientation);
        }
    }

    private int normalize(int degrees) {
        if (degrees > 315 || degrees <= 45) {
            return 0;
        }
        if (degrees > 45 && degrees <= 135) {
            return 90;
        }
        if (degrees > 135 && degrees <= 225) {
            return 180;
        }
        if (degrees > 225 && degrees <= 315) {
            return 270;
        }
        throw new RuntimeException("The physics as we know them are no more. Watch out for anomalies.");
    }

    void rememberOrientation() {
        this.rememberedNormalizedOrientation = this.currentNormalizedOrientation;
    }

    int getRememberedOrientation() {
        return this.rememberedNormalizedOrientation;
    }
}

