/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.camera;

import android.app.Activity;
import android.hardware.Camera;

class RotationEventListener {
    private int deviceDisplayRotation = 0;
    private int cameraDisplayRotation = 0;

    RotationEventListener() {
    }

    void onRotationChanged(Activity activity, Camera.CameraInfo cameraInfo) {
        this.deviceDisplayRotation = RotationEventListener.deviceDisplayRotationInDegrees(activity);
        this.cameraDisplayRotation = RotationEventListener.cameraDisplayRotation(cameraInfo, this.deviceDisplayRotation);
    }

    int getDeviceDisplayRotation() {
        return this.deviceDisplayRotation;
    }

    int getCameraDisplayRotation() {
        return this.cameraDisplayRotation;
    }

    private static int cameraDisplayRotation(Camera.CameraInfo cameraInfo, int deviceDisplayRotationDegrees) {
        int cameraDisplayRotation = 0;
        if (cameraInfo.facing == 1) {
            cameraDisplayRotation = (cameraInfo.orientation + deviceDisplayRotationDegrees) % 360;
            cameraDisplayRotation = (360 - cameraDisplayRotation) % 360;
        } else {
            cameraDisplayRotation = (cameraInfo.orientation - deviceDisplayRotationDegrees + 360) % 360;
        }
        return cameraDisplayRotation;
    }

    private static int deviceDisplayRotationInDegrees(Activity activity) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        return degrees;
    }
}

