/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

public final class OidcUtils {
    private static final Pattern CLAIM_PATH_PATTERN = Pattern.compile("\\/(?=(?:(?:[^\"]*\"){2})*[^\"]*$)");

    private OidcUtils() {
    }

    public static boolean validateClaims(OidcTenantConfig.Token tokenConfig, JsonObject json) {
        if (tokenConfig.issuer.isPresent()) {
            String issuer = json.getString(Claims.iss.name());
            if (!tokenConfig.issuer.get().equals(issuer)) {
                throw new OIDCException("Invalid issuer");
            }
        }
        if (tokenConfig.audience.isPresent()) {
            Object claimValue = json.getValue(Claims.aud.name());
            List<Object> audience = Collections.emptyList();
            if (claimValue instanceof JsonArray) {
                audience = OidcUtils.convertJsonArrayToList((JsonArray)claimValue);
            } else if (claimValue != null) {
                audience = Arrays.asList((String)claimValue);
            }
            if (!audience.containsAll((Collection)tokenConfig.audience.get())) {
                throw new OIDCException("Invalid audience");
            }
        }
        return true;
    }

    public static List<String> findRoles(String clientId, OidcTenantConfig.Roles rolesConfig, JsonObject json) {
        if (rolesConfig.getRoleClaimPath().isPresent()) {
            return OidcUtils.findClaimWithRoles(rolesConfig, rolesConfig.getRoleClaimPath().get(), json, true);
        }
        List<String> groups = OidcUtils.findClaimWithRoles(rolesConfig, Claims.groups.name(), json, false);
        if (!groups.isEmpty()) {
            return groups;
        }
        LinkedList<String> allRoles = new LinkedList<String>();
        allRoles.addAll(OidcUtils.findClaimWithRoles(rolesConfig, "realm_access/roles", json, false));
        if (clientId != null) {
            allRoles.addAll(OidcUtils.findClaimWithRoles(rolesConfig, "resource_access/" + clientId + "/roles", json, false));
        }
        return allRoles;
    }

    private static List<String> findClaimWithRoles(OidcTenantConfig.Roles rolesConfig, String claimPath, JsonObject json, boolean mustExist) {
        Object claimValue = OidcUtils.findClaimValue(claimPath, json, OidcUtils.splitClaimPath(claimPath), 0, mustExist);
        if (claimValue instanceof JsonArray) {
            return OidcUtils.convertJsonArrayToList((JsonArray)claimValue);
        }
        if (claimValue != null) {
            String sep = rolesConfig.getRoleClaimSeparator().isPresent() ? rolesConfig.getRoleClaimSeparator().get() : " ";
            return Arrays.asList(claimValue.toString().split(sep));
        }
        return Collections.emptyList();
    }

    private static String[] splitClaimPath(String claimPath) {
        String[] stringArray;
        if (claimPath.indexOf(47) > 0) {
            stringArray = CLAIM_PATH_PATTERN.split(claimPath);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = claimPath;
        }
        return stringArray;
    }

    private static Object findClaimValue(String claimPath, JsonObject json, String[] pathArray, int step, boolean mustExist) {
        Object claimValue = json.getValue(pathArray[step].replace("\"", ""));
        if (claimValue == null) {
            if (mustExist) {
                throw new OIDCException("No claim exists at the path " + claimPath + " at the path segment " + pathArray[step]);
            }
        } else if (step + 1 < pathArray.length) {
            if (claimValue instanceof JsonObject) {
                int nextStep = step + 1;
                return OidcUtils.findClaimValue(claimPath, (JsonObject)claimValue, pathArray, nextStep, mustExist);
            }
            throw new OIDCException("Claim value at the path " + claimPath + " is not a json object");
        }
        return claimValue;
    }

    private static List<String> convertJsonArrayToList(JsonArray claimValue) {
        ArrayList<String> list = new ArrayList<String>(claimValue.size());
        for (int i = 0; i < claimValue.size(); ++i) {
            list.add(claimValue.getString(i));
        }
        return list;
    }

    static QuarkusSecurityIdentity validateAndCreateIdentity(TokenCredential credential, OidcTenantConfig config, JsonObject tokenJson) {
        OidcJwtCallerPrincipal jwtPrincipal;
        try {
            OidcUtils.validateClaims(config.getToken(), tokenJson);
        }
        catch (OIDCException e) {
            throw new AuthenticationFailedException((Throwable)e);
        }
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.addCredential((Credential)credential);
        try {
            JwtClaims jwtClaims = JwtClaims.parse((String)tokenJson.encode());
            jwtClaims.setClaim(Claims.raw_token.name(), (Object)credential.getToken());
            jwtPrincipal = new OidcJwtCallerPrincipal(jwtClaims, credential, config.token.principalClaim.isPresent() ? config.token.principalClaim.get() : null);
        }
        catch (InvalidJwtException e) {
            throw new AuthenticationFailedException((Throwable)e);
        }
        builder.setPrincipal((Principal)((Object)jwtPrincipal));
        try {
            String clientId = config.getClientId().isPresent() ? config.getClientId().get() : null;
            for (String role : OidcUtils.findRoles(clientId, config.getRoles(), tokenJson)) {
                builder.addRole(role);
            }
        }
        catch (Exception e) {
            throw new ForbiddenException((Throwable)e);
        }
        return builder.build();
    }
}

