/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.process.svg.model.NodeSummary;
import org.jbpm.process.svg.model.RenderType;
import org.jbpm.process.svg.model.SetSubProcessLinkTransformation;
import org.jbpm.process.svg.processor.AbstractSVGProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGElement;

public class StunnerSVGProcessor
extends AbstractSVGProcessor {
    private static String SPECIAL_SUB_PROCESS_INSTANCE_ID = "_subProcessReusableNormalReusableIcon";
    private static String OLD_SPECIAL_SUB_PROCESS_INSTANCE_ID = "undefined";
    private Map<String, String> subProcessLinks;
    private Map<String, Long> nodeBadges = new HashMap<String, Long>();

    public StunnerSVGProcessor(Document svgDocument) {
        super(svgDocument, true);
    }

    public void setSubProcessLinks(Map<String, String> subProcessLinks) {
        this.subProcessLinks = subProcessLinks;
    }

    public void setNodeBadges(Map<String, Long> nodeBadges) {
        this.nodeBadges = nodeBadges;
    }

    @Override
    public void defaultCompletedTransformation(String nodeId, String completedNodeColor, String completedNodeBorderColor) {
        this.transform(summary -> Optional.ofNullable(summary.getNode(nodeId)).ifPresent(node -> Optional.ofNullable(node.getBackground()).ifPresent(background -> {
            background.setAttribute("fill", completedNodeColor);
            this.setNodeBorderColor(node.getRenderType(), node.getBorder(), completedNodeBorderColor);
        })));
    }

    @Override
    public void defaultActiveTransformation(String nodeId, String activeNodeBorderColor) {
        this.defaultBorderTransformation(nodeId, activeNodeBorderColor);
    }

    @Override
    public void defaultActiveAsyncTransformation(String nodeId, String activeAsyncNodeBorderColor) {
        this.defaultBorderTransformation(nodeId, activeAsyncNodeBorderColor);
    }

    public void defaultBorderTransformation(String nodeId, String nodeBorderColor) {
        this.transform(summary -> Optional.ofNullable(summary.getNode(nodeId)).ifPresent(node -> Optional.ofNullable(node.getBorder()).ifPresent(border -> this.setNodeBorderColor(node.getRenderType(), (Element)border, nodeBorderColor))));
    }

    private void setNodeBorderColor(Optional<RenderType> renderType, Element border, String color) {
        RenderType render = renderType.orElse(RenderType.STROKE);
        switch (render) {
            case STROKE: {
                border.setAttribute("stroke-width", "2");
                border.setAttribute("stroke", color);
                break;
            }
            case FILL: {
                border.setAttribute("fill", color);
            }
        }
    }

    @Override
    public void defaultSubProcessLinkTransformation(String nodeId, String link) {
        this.transform(new SetSubProcessLinkTransformation(nodeId, link));
    }

    private void processNode(Node parent, String nodeId) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node svgIdNode;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (svgIdNode = attributes.getNamedItem("id")) != null) {
                String value = svgIdNode.getNodeValue();
                if (!Objects.nonNull(value)) break;
                Map<String, String> parameters = Stream.of(value.substring(value.indexOf("?") + 1)).filter(Objects::nonNull).map(str -> Collections.list(new StringTokenizer((String)str, "&"))).flatMap(list -> list.stream()).map(String::valueOf).filter(str -> str.split("=").length == 2).collect(Collectors.toMap(v -> v.split("=")[0], v -> v.split("=")[1]));
                NodeSummary nodeSummary = this.summary.getNodesMap().getOrDefault(nodeId, new NodeSummary(nodeId, null, null, null, null, null));
                Element border = Objects.equals(parameters.get("shapeType"), "BORDER") ? (Element)node : nodeSummary.getBorder();
                Element background = Objects.equals(parameters.get("shapeType"), "BACKGROUND") ? (Element)node : nodeSummary.getBackground();
                RenderType renderType = RenderType.valueOf(Optional.ofNullable(parameters.get("renderType")).orElse(nodeSummary.getRenderType().orElse(RenderType.STROKE).name()));
                Element plusButton = null;
                if (this.subProcessLinks != null && this.subProcessLinks.containsKey(nodeId) && (value.equals(nodeId + SPECIAL_SUB_PROCESS_INSTANCE_ID) || value.equals(nodeId + OLD_SPECIAL_SUB_PROCESS_INSTANCE_ID))) {
                    plusButton = (Element)node;
                }
                if (!value.contains(nodeId)) break;
                this.summary.addNode(new NodeSummary(nodeId, border, background, null, null, renderType, plusButton));
                break;
            }
            this.processNode(node, nodeId);
        }
    }

    private void renderBadges(Node node, Long badgesCount) {
        Element svgElement = (Element)node;
        String nodeId = ((SVGElement)svgElement).getId();
        Element jbpmNodeBadge = this.svgDocument.createElement("g");
        jbpmNodeBadge.setAttribute("jbpm-node-badge", nodeId);
        Element jbpmNodeBadgeRect = this.svgDocument.createElement("rect");
        Element jbpmNodeBadgeText = this.svgDocument.createElement("text");
        jbpmNodeBadgeRect.setAttribute("x", "0");
        jbpmNodeBadgeRect.setAttribute("y", "0");
        jbpmNodeBadgeRect.setAttribute("width", "25");
        jbpmNodeBadgeRect.setAttribute("height", "20");
        jbpmNodeBadgeRect.setAttribute("rx", "5");
        jbpmNodeBadgeRect.setAttribute("ry", "5");
        jbpmNodeBadgeRect.setAttribute("fill", "grey");
        jbpmNodeBadgeRect.setAttribute("opacity", "0.5");
        jbpmNodeBadgeText.setAttribute("font-size", "10pt");
        jbpmNodeBadgeText.setAttribute("font-weight", "normal");
        jbpmNodeBadgeText.setAttribute("font-family", "Open Sans");
        jbpmNodeBadgeText.setAttribute("font-style", "normal");
        jbpmNodeBadgeText.setAttribute("text-anchor", "middle");
        jbpmNodeBadgeText.setAttribute("fill", "white");
        jbpmNodeBadgeText.setAttribute("x", "12");
        jbpmNodeBadgeText.setAttribute("y", "15");
        jbpmNodeBadgeText.setTextContent(String.valueOf(badgesCount));
        jbpmNodeBadge.appendChild(jbpmNodeBadgeRect);
        jbpmNodeBadge.appendChild(jbpmNodeBadgeText);
        svgElement.appendChild(jbpmNodeBadge);
    }

    @Override
    public void processNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nodeIdNode;
            Node svgIdNode;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (svgIdNode = attributes.getNamedItem("id")) != null && (nodeIdNode = attributes.getNamedItem("bpmn2nodeid")) != null) {
                String nodeId = nodeIdNode.getNodeValue();
                if (this.nodeBadges != null) {
                    this.nodeBadges.computeIfPresent(nodeId, (key, value) -> {
                        this.renderBadges(node, (Long)value);
                        return null;
                    });
                }
                if (nodeId != null) {
                    this.processNode(node, nodeId);
                }
            }
            this.processNodes(node.getChildNodes());
        }
    }
}

