/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.addon;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.addon.DependencyFilter;
import org.drools.compiler.addon.MinimalPomParser;
import org.kie.api.builder.ReleaseId;

public interface PomModel {
    public ReleaseId getReleaseId();

    public ReleaseId getParentReleaseId();

    public Collection<ReleaseId> getDependencies();

    public Collection<ReleaseId> getDependencies(DependencyFilter var1);

    public static class Parser {
        public static PomModel parse(String path, InputStream is) {
            return MinimalPomParser.parse(path, is);
        }
    }

    public static class InternalModel
    implements PomModel {
        private ReleaseId releaseId;
        private ReleaseId parentReleaseId;
        private final Map<String, Set<ReleaseId>> dependencies = new HashMap<String, Set<ReleaseId>>();

        @Override
        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        public void setReleaseId(ReleaseId releaseId) {
            this.releaseId = releaseId;
        }

        @Override
        public ReleaseId getParentReleaseId() {
            return this.parentReleaseId;
        }

        public void setParentReleaseId(ReleaseId parentReleaseId) {
            this.parentReleaseId = parentReleaseId;
        }

        @Override
        public Collection<ReleaseId> getDependencies() {
            return this.getDependencies(DependencyFilter.TAKE_ALL_FILTER);
        }

        @Override
        public Collection<ReleaseId> getDependencies(DependencyFilter filter) {
            HashSet<ReleaseId> depSet = new HashSet<ReleaseId>();
            for (Map.Entry<String, Set<ReleaseId>> entry : this.dependencies.entrySet()) {
                for (ReleaseId releaseId : entry.getValue()) {
                    if (!filter.accept(releaseId, entry.getKey())) continue;
                    depSet.add(releaseId);
                }
            }
            return depSet;
        }

        protected void addDependency(ReleaseId dependency, String scope) {
            Set<ReleaseId> depsByScope = this.dependencies.get(scope);
            if (depsByScope == null) {
                depsByScope = new HashSet<ReleaseId>();
                this.dependencies.put(scope, depsByScope);
            }
            depsByScope.add(dependency);
        }
    }
}

