/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AccumulateImportDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.kie.api.io.Resource;
import org.kie.internal.builder.ResourceChange;

public class CompositePackageDescr
extends PackageDescr {
    private CompositeAssetFilter filter;

    public CompositePackageDescr() {
    }

    public CompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        super(packageDescr.getNamespace(), packageDescr.getDocumentation());
        this.internalAdd(resource, packageDescr);
    }

    public void addPackageDescr(Resource resource, PackageDescr packageDescr) {
        if (!this.getNamespace().equals(packageDescr.getNamespace())) {
            throw new RuntimeException("Composing PackageDescr (" + packageDescr.getName() + ") in different namespaces (namespace=" + this.getNamespace() + " packageDescr=" + packageDescr.getNamespace() + ")");
        }
        this.internalAdd(resource, packageDescr);
    }

    private void internalAdd(Resource resource, PackageDescr packageDescr) {
        List<ImportDescr> currentImports = this.getImports();
        for (ImportDescr importDescr : packageDescr.getImports()) {
            if (currentImports.contains(importDescr)) continue;
            this.addImport(importDescr);
            importDescr.setResource(resource);
        }
        List<FunctionImportDescr> currentFunctionImports = this.getFunctionImports();
        for (FunctionImportDescr functionImportDescr : packageDescr.getFunctionImports()) {
            if (currentFunctionImports.contains(functionImportDescr)) continue;
            this.addFunctionImport(functionImportDescr);
            functionImportDescr.setResource(resource);
        }
        List<AccumulateImportDescr> list = this.getAccumulateImports();
        for (AccumulateImportDescr accumulateImportDescr : packageDescr.getAccumulateImports()) {
            if (list.contains(accumulateImportDescr)) continue;
            this.addAccumulateImport(accumulateImportDescr);
            accumulateImportDescr.setResource(resource);
        }
        List<AttributeDescr> list2 = this.getAttributes();
        for (AttributeDescr attributeDescr : packageDescr.getAttributes()) {
            if (list2.contains(attributeDescr)) continue;
            this.addAttribute(attributeDescr);
            attributeDescr.setResource(resource);
        }
        List<GlobalDescr> list3 = this.getGlobals();
        for (GlobalDescr globalDescr : packageDescr.getGlobals()) {
            if (list3.contains(globalDescr)) continue;
            this.addGlobal(globalDescr);
            globalDescr.setResource(resource);
        }
        List<FunctionDescr> list4 = this.getFunctions();
        for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
            if (list4.contains(functionDescr)) continue;
            this.addFunction(functionDescr);
            functionDescr.setResource(resource);
        }
        List<RuleDescr> list5 = this.getRules();
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            if (list5.contains(ruleDescr)) continue;
            this.addRule(ruleDescr);
            ruleDescr.setResource(resource);
        }
        List<TypeDeclarationDescr> list6 = this.getTypeDeclarations();
        for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
            if (list6.contains(typeDeclarationDescr)) continue;
            this.addTypeDeclaration(typeDeclarationDescr);
            typeDeclarationDescr.setResource(resource);
        }
        List<EnumDeclarationDescr> list7 = this.getEnumDeclarations();
        for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
            if (list7.contains(enumDeclarationDescr)) continue;
            this.addEnumDeclaration(enumDeclarationDescr);
            enumDeclarationDescr.setResource(resource);
        }
        Set<EntryPointDeclarationDescr> set = this.getEntryPointDeclarations();
        for (EntryPointDeclarationDescr descr : packageDescr.getEntryPointDeclarations()) {
            if (set.contains(descr)) continue;
            this.addEntryPointDeclaration(descr);
            descr.setResource(resource);
        }
        Set<WindowDeclarationDescr> set2 = this.getWindowDeclarations();
        for (WindowDeclarationDescr descr : packageDescr.getWindowDeclarations()) {
            if (set2.contains(descr)) continue;
            this.addWindowDeclaration(descr);
            descr.setResource(resource);
        }
    }

    public CompositeAssetFilter getFilter() {
        return this.filter;
    }

    public void addFilter(KnowledgeBuilderImpl.AssetFilter f) {
        if (f != null) {
            if (this.filter == null) {
                this.filter = new CompositeAssetFilter();
            }
            this.filter.filters.add(f);
        }
    }

    public static class CompositeAssetFilter
    implements KnowledgeBuilderImpl.AssetFilter {
        public List<KnowledgeBuilderImpl.AssetFilter> filters = new ArrayList<KnowledgeBuilderImpl.AssetFilter>();

        @Override
        public KnowledgeBuilderImpl.AssetFilter.Action accept(ResourceChange.Type type, String pkgName, String assetName) {
            for (KnowledgeBuilderImpl.AssetFilter filter : this.filters) {
                KnowledgeBuilderImpl.AssetFilter.Action result = filter.accept(type, pkgName, assetName);
                if (KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING.equals((Object)result)) continue;
                return result;
            }
            return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
        }
    }
}

