/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.events.EventsActions;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.transitions.Transition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"exclusive", "eventsActions", "timeout"})
public class EventState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="exclusive")
    @JsonPropertyDescription(value="If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed")
    private boolean exclusive = true;
    @JsonProperty(value="eventsActions")
    @JsonPropertyDescription(value="Define what events trigger one or more actions to be performed")
    @Valid
    @NotNull
    private List<EventsActions> eventsActions = new ArrayList<EventsActions>();
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Time period to wait for incoming events (ISO 8601 format)")
    private String timeout;
    private static final long serialVersionUID = -8152205520756253422L;

    public EventState() {
    }

    public EventState(List<EventsActions> eventsActions, String name, DefaultState.Type type) {
        super(name, type);
        this.eventsActions = eventsActions;
    }

    @JsonProperty(value="exclusive")
    public boolean isExclusive() {
        return this.exclusive;
    }

    @JsonProperty(value="exclusive")
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public EventState withExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    @JsonProperty(value="eventsActions")
    public List<EventsActions> getEventsActions() {
        return this.eventsActions;
    }

    @JsonProperty(value="eventsActions")
    public void setEventsActions(List<EventsActions> eventsActions) {
        this.eventsActions = eventsActions;
    }

    public EventState withEventsActions(List<EventsActions> eventsActions) {
        this.eventsActions = eventsActions;
        return this;
    }

    @JsonProperty(value="timeout")
    public String getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public EventState withTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public EventState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public EventState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public EventState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public EventState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public EventState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public EventState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public EventState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public EventState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public EventState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public EventState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public EventState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public EventState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }
}

