/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.transitions.Transition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"inputCollection", "outputCollection", "inputParameter", "max", "timeDelay", "states"})
public class ForEachState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="inputCollection")
    @JsonPropertyDescription(value="JSONPath expression selecting an JSON array element of the states data input")
    @NotNull
    private String inputCollection;
    @JsonProperty(value="outputCollection")
    @JsonPropertyDescription(value="JSONPath expression specifying where in the states data output to place the final data output of each iteration of the executed states")
    private String outputCollection;
    @JsonProperty(value="inputParameter")
    @JsonPropertyDescription(value="JSONPath expression specifying an JSON object field of the states data input. For each parallel iteration, this field will get populated with a unique element of the inputCollection array")
    @NotNull
    private String inputParameter;
    @JsonProperty(value="max")
    @JsonPropertyDescription(value="Specifies how upper bound on how many iterations may run in parallel")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") int max = 0;
    @JsonProperty(value="timeDelay")
    @JsonPropertyDescription(value="Amount of time (ISO 8601 format) to wait between each iteration ")
    private String timeDelay;
    @JsonProperty(value="states")
    @JsonPropertyDescription(value="States to be executed for each of the elements of inputCollection")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    private static final long serialVersionUID = -6062804359170416984L;

    public ForEachState() {
    }

    public ForEachState(String inputCollection, String inputParameter, List<State> states, String name, DefaultState.Type type) {
        super(name, type);
        this.inputCollection = inputCollection;
        this.inputParameter = inputParameter;
        this.states = states;
    }

    @JsonProperty(value="inputCollection")
    public String getInputCollection() {
        return this.inputCollection;
    }

    @JsonProperty(value="inputCollection")
    public void setInputCollection(String inputCollection) {
        this.inputCollection = inputCollection;
    }

    public ForEachState withInputCollection(String inputCollection) {
        this.inputCollection = inputCollection;
        return this;
    }

    @JsonProperty(value="outputCollection")
    public String getOutputCollection() {
        return this.outputCollection;
    }

    @JsonProperty(value="outputCollection")
    public void setOutputCollection(String outputCollection) {
        this.outputCollection = outputCollection;
    }

    public ForEachState withOutputCollection(String outputCollection) {
        this.outputCollection = outputCollection;
        return this;
    }

    @JsonProperty(value="inputParameter")
    public String getInputParameter() {
        return this.inputParameter;
    }

    @JsonProperty(value="inputParameter")
    public void setInputParameter(String inputParameter) {
        this.inputParameter = inputParameter;
    }

    public ForEachState withInputParameter(String inputParameter) {
        this.inputParameter = inputParameter;
        return this;
    }

    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    @JsonProperty(value="max")
    public void setMax(int max) {
        this.max = max;
    }

    public ForEachState withMax(int max) {
        this.max = max;
        return this;
    }

    @JsonProperty(value="timeDelay")
    public String getTimeDelay() {
        return this.timeDelay;
    }

    @JsonProperty(value="timeDelay")
    public void setTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public ForEachState withTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
        return this;
    }

    @JsonProperty(value="states")
    public List<State> getStates() {
        return this.states;
    }

    @JsonProperty(value="states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public ForEachState withStates(List<State> states) {
        this.states = states;
        return this;
    }

    @Override
    public ForEachState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ForEachState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ForEachState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ForEachState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public ForEachState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ForEachState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ForEachState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ForEachState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ForEachState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public ForEachState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public ForEachState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public ForEachState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }
}

