/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jbpm.serverless.workflow.api.WorkflowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowManagerProvider {
    private WorkflowManager workflowManager;
    private static Logger logger = LoggerFactory.getLogger(WorkflowManagerProvider.class);

    public WorkflowManagerProvider() {
        ServiceLoader<WorkflowManager> foundWorkflowManagers = ServiceLoader.load(WorkflowManager.class);
        Iterator<WorkflowManager> it = foundWorkflowManagers.iterator();
        if (it.hasNext()) {
            this.workflowManager = it.next();
            logger.info("Found workflow manager: {}", (Object)this.workflowManager);
        }
    }

    public static WorkflowManagerProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public WorkflowManager get() {
        if (this.workflowManager.getWorkflowValidator() != null) {
            this.workflowManager.getWorkflowValidator().reset();
            this.workflowManager.resetExpressionValidator();
        }
        return this.workflowManager;
    }

    private static class LazyHolder {
        static final WorkflowManagerProvider INSTANCE = new WorkflowManagerProvider();

        private LazyHolder() {
        }
    }
}

