/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.Duration;
import org.kie.soup.commons.validation.Preconditions;

public class SolverHandlerConfig {
    private String targetUserId;
    private int publishWindowSize;
    private Duration syncInterval;
    private Duration syncQueriesShift;
    private Duration usersSyncInterval;
    private Duration waitForImprovedSolutionDuration;
    private Duration improveSolutionOnBackgroundDuration;
    private long initDelay;

    public SolverHandlerConfig(String targetUserId, int publishWindowSize, Duration syncInterval, Duration syncQueriesShift, Duration usersSyncInterval, Duration waitForImprovedSolutionDuration, Duration improveSolutionOnBackgroundDuration, long initDelay) {
        if (targetUserId == null || targetUserId.isEmpty()) {
            throw new IllegalArgumentException("A non empty targetUserId is expected.");
        }
        Preconditions.checkGreaterThan((String)"publishWindowSize", (Comparable)Integer.valueOf(publishWindowSize), (Object)0);
        Preconditions.checkGreaterThan((String)"syncInterval", (Comparable)syncInterval, (Object)Duration.ZERO);
        Preconditions.checkGreaterThan((String)"syncQueriesShift", (Comparable)syncQueriesShift, (Object)Duration.ZERO);
        Preconditions.checkGreaterOrEqualTo((String)"usersSyncInterval", (Comparable)usersSyncInterval, (Object)Duration.ZERO);
        Preconditions.checkGreaterOrEqualTo((String)"waitForImprovedSolutionDuration", (Comparable)waitForImprovedSolutionDuration, (Object)Duration.ZERO);
        Preconditions.checkGreaterOrEqualTo((String)"improveSolutionOnBackgroundDuration", (Comparable)improveSolutionOnBackgroundDuration, (Object)Duration.ZERO);
        Preconditions.checkGreaterOrEqualTo((String)"initDelay", (Comparable)Long.valueOf(initDelay), (Object)0L);
        this.targetUserId = targetUserId;
        this.publishWindowSize = publishWindowSize;
        this.syncInterval = syncInterval;
        this.syncQueriesShift = syncQueriesShift;
        this.usersSyncInterval = usersSyncInterval;
        this.waitForImprovedSolutionDuration = waitForImprovedSolutionDuration;
        this.improveSolutionOnBackgroundDuration = improveSolutionOnBackgroundDuration;
        this.initDelay = initDelay;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public int getPublishWindowSize() {
        return this.publishWindowSize;
    }

    public Duration getSyncInterval() {
        return this.syncInterval;
    }

    public Duration getSyncQueriesShift() {
        return this.syncQueriesShift;
    }

    public Duration getUsersSyncInterval() {
        return this.usersSyncInterval;
    }

    public Duration getWaitForImprovedSolutionDuration() {
        return this.waitForImprovedSolutionDuration;
    }

    public Duration getImproveSolutionOnBackgroundDuration() {
        return this.improveSolutionOnBackgroundDuration;
    }

    public long getInitDelay() {
        return this.initDelay;
    }
}

