/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.data;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.services.taskassigning.planning.data.AbstractAttributeMapValueLabelValueExtractor;

public abstract class AbstractStringListValueAttributeMapValueExtractor<M extends Map<String, ?>, T>
extends AbstractAttributeMapValueLabelValueExtractor<M, T> {
    public static final String COMMA_SEPARATOR = ",";
    protected final String separator;

    protected AbstractStringListValueAttributeMapValueExtractor(String attributeName, String separator, Class<T> type, String labelName, int priority) {
        super(attributeName, type, labelName, priority);
        this.separator = separator;
    }

    @Override
    protected Set<Object> extractFromAttribute(Object attributeValue) {
        if (attributeValue == null) {
            return Collections.emptySet();
        }
        String[] valueSplit = attributeValue.toString().split(this.separator);
        return Stream.of(valueSplit).map(StringUtils::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }
}

