/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.client.AbstractClientResponse;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.util.AutoReleasingInputStream;
import org.apache.abdera.protocol.util.EncodingUtil;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsResponse
extends AbstractClientResponse
implements ClientResponse {
    private final HttpMethod method;

    protected CommonsResponse(Abdera abdera, HttpMethod method) {
        super(abdera);
        if (!method.isRequestSent()) {
            throw new IllegalStateException();
        }
        this.method = method;
        this.parse_cc();
        this.getServerDate();
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public String getMethod() {
        return this.method.getName();
    }

    @Override
    public int getStatus() {
        return this.method.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.method.getStatusText();
    }

    @Override
    public void release() {
        this.method.releaseConnection();
    }

    @Override
    public String getHeader(String header) {
        Header h = this.method.getResponseHeader(header);
        return h != null ? h.getValue() : null;
    }

    @Override
    public Object[] getHeaders(String header) {
        Header[] headers = this.method.getResponseHeaders(header);
        ArrayList<String> values = new ArrayList<String>();
        for (Header h : headers) {
            values.add(h.getValue());
        }
        return values.toArray(new Object[values.size()]);
    }

    public Map<String, Object[]> getHeaders() {
        Header[] headers = this.method.getResponseHeaders();
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        for (Header header : headers) {
            Object[] values = (Object[])map.get(header.getName());
            List<Object> list = values == null ? new ArrayList() : Arrays.asList(values);
            list.add(header.getValue());
            map.put(header.getName(), list.toArray(new Object[list.size()]));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String[] getHeaderNames() {
        Header[] headers = this.method.getResponseHeaders();
        ArrayList<String> list = new ArrayList<String>();
        for (Header h : headers) {
            String name = h.getName();
            if (list.contains(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getUri() {
        try {
            return this.method.getURI().toString();
        }
        catch (URIException uRIException) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            String ce = this.getHeader("Content-Encoding");
            this.in = this.method.getResponseBodyAsStream();
            if (ce != null) {
                this.in = EncodingUtil.getDecodingInputStream(this.in, ce);
            }
            this.in = new AutoReleasingInputStream(this.method, this.in);
        }
        return this.in;
    }
}

