/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.axiom.attachments.utils.ByteSearch;

public class BoundaryPushbackInputStream
extends InputStream {
    PushbackInputStream is;
    boolean boundaryFound;
    byte[] boundary;
    int rnBoundaryLen;
    byte[] buffer;
    int bufferSize;
    int numBytes;
    int index = -1;
    int bIndex = -1;
    final int MIN_BUF_SIZE = 32;
    protected static final int BOUNDARY_NT_FOUND = -1;
    private short[] skip = null;

    public BoundaryPushbackInputStream(PushbackInputStream inStream, byte[] boundary, int pushBackSize) {
        this.is = inStream;
        this.boundary = boundary;
        this.rnBoundaryLen = boundary.length + 2;
        this.bufferSize = Math.max(this.rnBoundaryLen * 2, pushBackSize);
    }

    private final int readFromStream(byte[] b, int start, int length) throws IOException {
        int minRead = Math.max(this.rnBoundaryLen * 2, length);
        minRead = Math.min(minRead, length - start);
        int br = 0;
        int brTotal = 0;
        do {
            if ((br = this.is.read(b, brTotal + start, length - brTotal)) <= 0) continue;
            brTotal += br;
        } while (br > -1 && brTotal < minRead);
        return brTotal != 0 ? brTotal : br;
    }

    private final int readFromStream(byte[] b) throws IOException {
        return this.readFromStream(b, 0, b.length);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read < 0) {
            return -1;
        }
        return b[0];
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.boundaryFound) {
            return -1;
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
            this.numBytes = this.readFromStream(this.buffer);
            if (this.numBytes < 0) {
                this.buffer = null;
                this.boundaryFound = true;
            }
            this.index = 0;
            this.bIndex = this.boundaryPosition(this.buffer, this.index, this.numBytes);
            if (this.bIndex >= 0) {
                this.unread();
            }
        }
        int bwritten = 0;
        do {
            int bcopy = Math.min(this.numBytes - this.rnBoundaryLen - this.index, len - bwritten);
            if (this.bIndex >= 0) {
                bcopy = Math.min(bcopy, this.bIndex - this.index);
            }
            if (bcopy > 0) {
                System.arraycopy(this.buffer, this.index, b, off + bwritten, bcopy);
                bwritten += bcopy;
                this.index += bcopy;
            }
            if (this.index == this.bIndex) {
                this.boundaryFound = true;
                continue;
            }
            if (bwritten >= len) continue;
            byte[] dstbuf = this.buffer;
            int movecnt = this.numBytes - this.index;
            System.arraycopy(this.buffer, this.index, dstbuf, 0, movecnt);
            int readcnt = this.readFromStream(dstbuf, movecnt, dstbuf.length - movecnt);
            if (readcnt < 0) {
                this.buffer = null;
                this.boundaryFound = true;
                throw new IOException("End of Stream, but boundary not found");
            }
            this.numBytes = readcnt + movecnt;
            this.buffer = dstbuf;
            this.index = 0;
            if (this.bIndex >= 0) {
                this.bIndex -= movecnt;
                continue;
            }
            this.bIndex = this.boundaryPosition(this.buffer, this.index, this.numBytes);
            if (this.bIndex < 0) continue;
            this.unread();
        } while (!this.boundaryFound && bwritten < len);
        if (this.boundaryFound) {
            this.buffer = null;
        }
        return bwritten;
    }

    private void unread() throws IOException {
        int i = this.bIndex;
        i = this.buffer[i] == 13 ? (i += this.rnBoundaryLen) : (i += this.boundary.length);
        if (this.numBytes - i > 0) {
            this.is.unread(this.buffer, i, this.numBytes - i);
        }
    }

    protected int boundaryPosition(byte[] searchbuf, int start, int end) throws IOException {
        int foundAt;
        if (this.skip == null) {
            this.skip = ByteSearch.getSkipArray(this.boundary, true);
        }
        if ((foundAt = ByteSearch.skipSearch(this.boundary, true, searchbuf, start, end, this.skip)) >= 0 && foundAt + this.rnBoundaryLen > end) {
            foundAt = -1;
        }
        if (foundAt >= 2 && searchbuf[foundAt - 2] == 13 && searchbuf[foundAt - 1] == 10) {
            foundAt -= 2;
        }
        return foundAt;
    }

    public boolean getBoundaryStatus() {
        return this.boundaryFound;
    }
}

