/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.ConfigurableDataHandler;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;

public class MIMEOutputUtils {
    private static byte[] CRLF = new byte[]{13, 10};

    public static void complete(OutputStream outStream, StringWriter writer, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        try {
            MIMEOutputUtils.startWritingMime(outStream, boundary);
            DataHandler dh = new DataHandler(writer.toString(), "text/xml; charset=" + charSetEncoding);
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", "application/xop+xml; charset=" + charSetEncoding + "; type=\"" + SOAPContentType + "\"");
            rootMimeBodyPart.addHeader("Content-Transfer-Encoding", "binary");
            rootMimeBodyPart.addHeader("Content-ID", "<" + contentId + ">");
            MIMEOutputUtils.writeBodyPart(outStream, rootMimeBodyPart, boundary);
            Iterator binaryNodeIterator = binaryNodeList.iterator();
            while (binaryNodeIterator.hasNext()) {
                OMText binaryNode = (OMText)binaryNodeIterator.next();
                MIMEOutputUtils.writeBodyPart(outStream, MIMEOutputUtils.createMimeBodyPart(binaryNode.getContentID(), (DataHandler)binaryNode.getDataHandler()), boundary);
            }
            MIMEOutputUtils.finishWritingMime(outStream);
            outStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static MimeBodyPart createMimeBodyPart(String contentID, DataHandler dataHandler) throws MessagingException {
        String encoding = null;
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.addHeader("Content-ID", "<" + contentID + ">");
        mimeBodyPart.addHeader("Content-Type", dataHandler.getContentType());
        if (dataHandler instanceof ConfigurableDataHandler) {
            ConfigurableDataHandler configurableDataHandler = (ConfigurableDataHandler)dataHandler;
            encoding = configurableDataHandler.getTransferEncoding();
        }
        if (encoding == null) {
            encoding = "binary";
        }
        mimeBodyPart.addHeader("Content-Transfer-Encoding", encoding);
        return mimeBodyPart;
    }

    public static void writeMimeBoundary(OutputStream outStream, String boundary) throws IOException {
        outStream.write(new byte[]{45, 45});
        outStream.write(boundary.getBytes("UTF-8"));
    }

    public static void startWritingMime(OutputStream outStream, String boundary) throws IOException {
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void writeBodyPart(OutputStream outStream, MimeBodyPart part, String boundary) throws IOException, MessagingException {
        outStream.write(CRLF);
        part.writeTo(outStream);
        outStream.write(CRLF);
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
        outStream.flush();
    }

    public static void finishWritingMime(OutputStream outStream) throws IOException {
        outStream.write(new byte[]{45, 45});
    }

    public static void writeSOAPWithAttachmentsMessage(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format) {
        try {
            String SOAPContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
            MIMEOutputUtils.startWritingMime(outputStream, format.getMimeBoundary());
            DataHandler dh = new DataHandler(writer.toString(), "text/xml; charset=" + format.getCharSetEncoding());
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", SOAPContentType + "; charset=" + format.getCharSetEncoding());
            rootMimeBodyPart.addHeader("Content-Transfer-Encoding", "8bit");
            rootMimeBodyPart.addHeader("Content-ID", "<" + format.getRootContentId() + ">");
            MIMEOutputUtils.writeBodyPart(outputStream, rootMimeBodyPart, format.getMimeBoundary());
            Iterator attachmentIDIterator = attachments.getContentIDSet().iterator();
            while (attachmentIDIterator.hasNext()) {
                String contentID = (String)attachmentIDIterator.next();
                DataHandler dataHandler = attachments.getDataHandler(contentID);
                MIMEOutputUtils.writeBodyPart(outputStream, MIMEOutputUtils.createMimeBodyPart(contentID, dataHandler), format.getMimeBoundary());
            }
            MIMEOutputUtils.finishWritingMime(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static void writeMM7Message(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format, String innerPartCID, String innerBoundary) {
        try {
            String SOAPContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
            MIMEOutputUtils.startWritingMime(outputStream, format.getMimeBoundary());
            DataHandler dh = new DataHandler(writer.toString(), "text/xml; charset=" + format.getCharSetEncoding());
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", SOAPContentType + "; charset=" + format.getCharSetEncoding());
            rootMimeBodyPart.addHeader("Content-ID", "<" + format.getRootContentId() + ">");
            MIMEOutputUtils.writeBodyPart(outputStream, rootMimeBodyPart, format.getMimeBoundary());
            if (attachments.getContentIDSet().size() != 0) {
                outputStream.write(CRLF);
                StringBuffer sb = new StringBuffer();
                sb.append("Content-Type: multipart/related");
                sb.append("; ");
                sb.append("boundary=");
                sb.append("\"" + innerBoundary + "\"");
                outputStream.write(sb.toString().getBytes());
                outputStream.write(CRLF);
                StringBuffer sb1 = new StringBuffer();
                sb1.append("Content-ID: ");
                sb1.append("<");
                sb1.append(innerPartCID);
                sb1.append(">");
                outputStream.write(sb1.toString().getBytes());
                outputStream.write(CRLF);
                outputStream.write(CRLF);
                MIMEOutputUtils.startWritingMime(outputStream, innerBoundary);
                Iterator attachmentIDIterator = attachments.getContentIDSet().iterator();
                while (attachmentIDIterator.hasNext()) {
                    String contentID = (String)attachmentIDIterator.next();
                    DataHandler dataHandler = attachments.getDataHandler(contentID);
                    MIMEOutputUtils.writeBodyPart(outputStream, MIMEOutputUtils.createMimeBodyPart(contentID, dataHandler), innerBoundary);
                }
                MIMEOutputUtils.finishWritingMime(outputStream);
                outputStream.write(CRLF);
                MIMEOutputUtils.writeMimeBoundary(outputStream, format.getMimeBoundary());
            }
            MIMEOutputUtils.finishWritingMime(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }
}

