/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.util.GregorianCalendar;

public abstract class ValueAdapter {
    public static final ValueAdapter STRING = new StringValueAdapter();
    public static final ValueAdapter DECIMAL = new DecimalValueAdapter();
    public static final ValueAdapter INTEGER = new IntegerValueAdapter();
    public static final ValueAdapter BOOLEAN = new BooleanValueAdapter();
    public static final ValueAdapter DATETIME = new DateTimeValueAdapter();
    public static final ValueAdapter URI = new UriValueAdapter();
    public static final ValueAdapter ID = new IdValueAdapter();
    public static final ValueAdapter HTML = new HtmlValueAdapter();
    protected static final Map<PropertyType, ValueAdapter> byPropertyType = new HashMap<PropertyType, ValueAdapter>();
    protected static final Map<QName, ValueAdapter> byQName = new HashMap<QName, ValueAdapter>();

    public abstract Serializable readValue(String var1);

    public abstract String writeValue(Serializable var1);

    public abstract Serializable[] createArray(int var1);

    public abstract QName getPropertyQName();

    public abstract PropertyType getPropertyType();

    public static ValueAdapter getAdapter(PropertyType type) {
        return byPropertyType.get(type);
    }

    public static ValueAdapter getAdapter(QName qname) {
        return byQName.get(qname);
    }

    static {
        for (ValueAdapter va : Arrays.asList(STRING, DECIMAL, INTEGER, BOOLEAN, DATETIME, URI, ID, HTML)) {
            byPropertyType.put(va.getPropertyType(), va);
            byQName.put(va.getPropertyQName(), va);
        }
    }

    protected static final class HtmlValueAdapter
    extends ValueAdapter {
        protected HtmlValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return xml;
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new String[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_HTML;
        }

        public PropertyType getPropertyType() {
            return PropertyType.HTML;
        }
    }

    protected static final class IdValueAdapter
    extends ValueAdapter {
        protected IdValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return xml;
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new String[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_ID;
        }

        public PropertyType getPropertyType() {
            return PropertyType.ID;
        }
    }

    protected static final class UriValueAdapter
    extends ValueAdapter {
        protected UriValueAdapter() {
        }

        public Serializable readValue(String xml) {
            try {
                return new URI(xml);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid URI: " + xml);
            }
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new String[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_URI;
        }

        public PropertyType getPropertyType() {
            return PropertyType.URI;
        }
    }

    protected static final class DateTimeValueAdapter
    extends ValueAdapter {
        protected DateTimeValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return GregorianCalendar.fromAtomPub(xml);
        }

        public String writeValue(Serializable val) {
            return val instanceof Calendar ? GregorianCalendar.toAtomPub((Calendar)val) : GregorianCalendar.toAtomPub((Date)val);
        }

        public Serializable[] createArray(int size) {
            return new Calendar[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_DATETIME;
        }

        public PropertyType getPropertyType() {
            return PropertyType.DATETIME;
        }
    }

    protected static final class BooleanValueAdapter
    extends ValueAdapter {
        protected BooleanValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return Boolean.valueOf(xml);
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new Boolean[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_BOOLEAN;
        }

        public PropertyType getPropertyType() {
            return PropertyType.BOOLEAN;
        }
    }

    protected static final class IntegerValueAdapter
    extends ValueAdapter {
        protected IntegerValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return Integer.valueOf(xml);
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new Integer[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_INTEGER;
        }

        public PropertyType getPropertyType() {
            return PropertyType.INTEGER;
        }
    }

    protected static final class DecimalValueAdapter
    extends ValueAdapter {
        protected DecimalValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return new BigDecimal(xml);
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new BigDecimal[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_DECIMAL;
        }

        public PropertyType getPropertyType() {
            return PropertyType.DECIMAL;
        }
    }

    protected static final class StringValueAdapter
    extends ValueAdapter {
        protected StringValueAdapter() {
        }

        public Serializable readValue(String xml) {
            return xml;
        }

        public String writeValue(Serializable val) {
            return val.toString();
        }

        public Serializable[] createArray(int size) {
            return new String[size];
        }

        public QName getPropertyQName() {
            return CMIS.PROPERTY_STRING;
        }

        public PropertyType getPropertyType() {
            return PropertyType.STRING;
        }
    }
}

