/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.abdera;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Repository;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.abdera.PropertiesElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectElement
extends ExtensibleElementWrapper {
    protected final PropertiesElement properties;

    public ObjectElement(Element internal, Repository repository) {
        super(internal);
        Object propsel = this.getFirstChild(CMIS.PROPERTIES);
        this.properties = propsel == null ? null : new PropertiesElement((Element)propsel, repository);
    }

    public ObjectElement(Factory factory, ObjectEntry object, Type type) {
        super(factory, AtomPubCMIS.OBJECT);
        this.properties = new PropertiesElement(this.getFactory());
        this.addExtension(this.properties);
        this.setProperties(object.getValues(), type);
    }

    public Map<String, Serializable> getProperties(String typeId) {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties.getProperties(typeId);
    }

    public void setProperties(Map<String, Serializable> values, Type type) {
        this.properties.setProperties(values, type);
    }
}

