/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.chemistry.ACE;
import org.apache.chemistry.ACLPropagation;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.Paging;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Rendition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Tree;
import org.apache.chemistry.Type;
import org.apache.chemistry.Unfiling;
import org.apache.chemistry.VersioningState;
import org.apache.chemistry.atompub.URITemplate;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPDocument;
import org.apache.chemistry.atompub.client.APPFolder;
import org.apache.chemistry.atompub.client.APPObject;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.atompub.client.APPRepository;
import org.apache.chemistry.atompub.client.Connector;
import org.apache.chemistry.atompub.client.NameValuePairs;
import org.apache.chemistry.atompub.client.stax.XmlProperty;
import org.apache.chemistry.impl.simple.SimpleListPage;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.commons.httpclient.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPConnection
implements Connection,
SPI {
    protected final APPRepository repository;
    protected final Connector connector;
    protected APPFolder root;

    public APPConnection(APPRepository repository, Map<String, Serializable> params) {
        this.repository = repository;
        this.connector = new Connector(repository.getClient(params), new APPContext(this));
    }

    public Connection getConnection() {
        return this;
    }

    @Override
    public SPI getSPI() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public Folder getRootFolder() {
        if (this.root == null) {
            this.root = (APPFolder)this.getObject(this.repository.info.getRootFolderId());
        }
        return this.root;
    }

    @Override
    public Document newDocument(String typeId, Folder folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.DOCUMENT) {
            throw new IllegalArgumentException(typeId);
        }
        APPObjectEntry entry = this.newObjectEntry(typeId);
        if (folder != null) {
            entry.addLink("up", ((APPFolder)folder).entry.getEditLink(), "application/atom+xml;type=entry");
        }
        return new APPDocument(entry, type);
    }

    @Override
    public Folder newFolder(String typeId, Folder folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException(typeId);
        }
        APPObjectEntry entry = this.newObjectEntry(typeId);
        if (folder != null) {
            entry._setValue("cmis:parentId", (Serializable)((Object)folder.getId()));
            entry.addLink("up", ((APPFolder)folder).entry.getEditLink(), "application/atom+xml;type=entry");
        }
        return new APPFolder(entry, type);
    }

    @Override
    public Relationship newRelationship(String typeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Policy newPolicy(String typeId, Folder folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public APPObjectEntry newObjectEntry(String typeId) {
        HashMap<String, XmlProperty> map = new HashMap<String, XmlProperty>();
        Type type = this.getRepository().getType(typeId);
        XmlProperty p = new XmlProperty(type.getPropertyDefinition("cmis:objectTypeId"), typeId);
        map.put(p.getId(), p);
        return new APPObjectEntry(this, map, null);
    }

    @Override
    public ObjectId newObjectId(String id) {
        return new SimpleObjectId(id);
    }

    @Override
    public Tree<ObjectEntry> getFolderTree(ObjectId folder, int depth, Inclusion inclusion) {
        String href = this.getFolderEntry(folder).getLink("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed");
        if (href == null) {
            throw new CMISRuntimeException("Missing foldertree link");
        }
        NameValuePairs params = new NameValuePairs();
        params.add("depth", Integer.toString(depth));
        if (inclusion != null) {
            if (inclusion.properties != null) {
                params.add("filter", inclusion.properties);
            }
            if (inclusion.renditions != null) {
                params.add("renditionFilter", inclusion.renditions);
            }
            if (inclusion.relationships != null) {
                params.add("includeRelationships", RelationshipDirection.toInclusion(inclusion.relationships));
            }
            params.add("includeAllowableActions", Boolean.toString(inclusion.allowableActions));
        }
        return this.connector.getEntryFeedTree(href, params);
    }

    @Override
    public Tree<ObjectEntry> getDescendants(ObjectId folder, int depth, String orderBy, Inclusion inclusion) {
        String href = this.getFolderEntry(folder).getLink("down", "application/cmistree+xml");
        if (href == null) {
            throw new CMISRuntimeException("Missing down tree link");
        }
        NameValuePairs params = new NameValuePairs();
        params.add("depth", Integer.toString(depth));
        if (orderBy != null) {
            params.add("orderBy", orderBy);
        }
        if (inclusion != null) {
            if (inclusion.properties != null) {
                params.add("filter", inclusion.properties);
            }
            if (inclusion.renditions != null) {
                params.add("renditionFilter", inclusion.renditions);
            }
            if (inclusion.relationships != null) {
                params.add("includeRelationships", RelationshipDirection.toInclusion(inclusion.relationships));
            }
            params.add("includeAllowableActions", Boolean.toString(inclusion.allowableActions));
            params.add("includePolicyIds", Boolean.toString(inclusion.policies));
            params.add("includeACL", Boolean.toString(inclusion.acls));
        }
        return this.connector.getEntryFeedTree(href, params);
    }

    @Override
    public ListPage<ObjectEntry> getChildren(ObjectId folder, Inclusion inclusion, String orderBy, Paging paging) {
        String href = this.getFolderEntry(folder).getLink("down", "application/atom+xml;type=feed");
        if (href == null) {
            throw new CMISRuntimeException("Missing down link");
        }
        NameValuePairs params = new NameValuePairs();
        if (paging != null) {
            params.add("maxItems", Integer.toString(paging.maxItems));
            params.add("skipCount", Integer.toString(paging.skipCount));
        }
        return this.connector.getEntryFeed(href, params);
    }

    @Override
    public ObjectEntry getFolderParent(ObjectId folder, String filter) {
        APPObjectEntry current = this.getFolderEntry(folder);
        String rootId = this.repository.getInfo().getRootFolderId().getId();
        if (current.getId().equals(rootId)) {
            return null;
        }
        String href = current.getLink("up", "application/atom+xml;type=entry");
        if (href == null) {
            return null;
        }
        return this.connector.getEntry(href, folder.getId());
    }

    @Override
    public Collection<ObjectEntry> getObjectParents(ObjectId object, String filter) {
        APPObjectEntry current = this.getObjectEntry(object);
        String href = current.getLink("up");
        if (href == null) {
            throw new CMISRuntimeException("Missing up link");
        }
        return this.connector.getEntryFeed(href, null);
    }

    @Override
    public ListPage<ObjectEntry> getCheckedOutDocuments(ObjectId folder, Inclusion inclusion, Paging paging) {
        throw new UnsupportedOperationException();
    }

    protected APPObjectEntry getObjectEntry(ObjectId objectId) {
        if (objectId instanceof APPObjectEntry) {
            return (APPObjectEntry)objectId;
        }
        if (objectId instanceof APPObject) {
            return ((APPObject)objectId).getEntry();
        }
        URITemplate uriTemplate = this.repository.getURITemplate("objectbyid");
        String href = uriTemplate.template;
        href = this.replace(href, "id", objectId.getId());
        href = this.replace(href, "filter", "");
        href = this.replace(href, "renditionFilter", "");
        href = this.replace(href, "includeRelationships", "");
        href = this.replace(href, "includeAllowableActions", "");
        href = this.replace(href, "includePolicyIds", "");
        href = this.replace(href, "includeACL", "");
        return this.connector.getEntry(href, objectId.getId());
    }

    protected APPObjectEntry getFolderEntry(ObjectId objectId) {
        APPObjectEntry entry = this.getObjectEntry(objectId);
        if (!entry.getBaseType().equals((Object)BaseType.FOLDER)) {
            throw new IllegalArgumentException("Not a folder: " + objectId);
        }
        return entry;
    }

    protected String replace(String template, String param, String value) {
        return template.replace('{' + param + '}', value);
    }

    @Override
    public CMISObject getObject(ObjectId object) {
        APPObjectEntry entry = this.getObjectEntry(object);
        Type type = this.getRepository().getType(entry.getTypeId());
        switch (entry.getBaseType()) {
            case DOCUMENT: {
                return new APPDocument(entry, type);
            }
            case FOLDER: {
                return new APPFolder(entry, type);
            }
            case POLICY: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            case RELATIONSHIP: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        throw new AssertionError((Object)entry.getBaseType());
    }

    protected String getPostHref(ObjectId parentId) {
        APPObjectEntry parentEntry = this.getObjectEntry(parentId);
        String href = parentEntry.getLink("down", "application/atom+xml;type=feed");
        if (href == null && (href = parentEntry.getLink("down", "application/atom+xml")) == null) {
            throw new IllegalArgumentException("Cannot create entry: no 'down' link present");
        }
        return href;
    }

    protected APPObjectEntry createObject(String href, Map<String, Serializable> properties, ContentStream contentStream, BaseType baseType) {
        String typeId = (String)((Object)properties.get("cmis:objectTypeId"));
        if (typeId == null) {
            throw new IllegalArgumentException("Missing object type id");
        }
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != baseType) {
            throw new IllegalArgumentException(typeId);
        }
        APPObjectEntry entry = this.newObjectEntry(typeId);
        for (Map.Entry<String, Serializable> en : properties.entrySet()) {
            entry._setValue(en.getKey(), en.getValue());
        }
        if (contentStream != null) {
            entry.setContentStream(contentStream);
        }
        return this.connector.postEntry(href, null, entry);
    }

    @Override
    public ObjectId createDocumentFromSource(ObjectId source, ObjectId folder, Map<String, Serializable> properties, VersioningState versioningState) throws NameConstraintViolationException {
        throw new CMISRuntimeException("AtomPub bindings do not support createDocumentFromSource");
    }

    @Override
    public ObjectId createDocument(Map<String, Serializable> properties, ObjectId folder, ContentStream contentStream, VersioningState versioningState) {
        return this.createObject(this.getPostHref(folder), properties, contentStream, BaseType.DOCUMENT);
    }

    @Override
    public ObjectId createFolder(Map<String, Serializable> properties, ObjectId folder) {
        return this.createObject(this.getPostHref(folder), properties, null, BaseType.FOLDER);
    }

    @Override
    public ObjectId createRelationship(Map<String, Serializable> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectId createPolicy(Map<String, Serializable> properties, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<QName> getAllowableActions(ObjectId object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectEntry getProperties(ObjectId object, Inclusion inclusion) {
        APPObjectEntry current = this.getObjectEntry(object);
        String href = current.getLink("self");
        try {
            return this.connector.getEntry(href, object.getId());
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    @Override
    public ObjectEntry getObjectByPath(String path, Inclusion inclusion) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with / : " + path);
        }
        if (!path.equals("/") && path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not end with / : " + path);
        }
        URITemplate uriTemplate = this.repository.getURITemplate("objectbypath");
        if (uriTemplate == null) {
            throw new UnsupportedOperationException("Cannot get object by path");
        }
        String encodedPath = path.replace(" ", "%20");
        String href = uriTemplate.template;
        href = this.replace(href, "path", encodedPath);
        href = this.replace(href, "filter", "");
        href = this.replace(href, "renditionFilter", "");
        href = this.replace(href, "includeRelationships", "");
        href = this.replace(href, "includeAllowableActions", "");
        href = this.replace(href, "includePolicyIds", "");
        href = this.replace(href, "includeACL", "");
        try {
            return this.connector.getEntry(href, path);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    @Override
    public Folder getFolder(String path) {
        APPObjectEntry entry = (APPObjectEntry)this.getObjectByPath(path, null);
        if (entry == null) {
            return null;
        }
        if (entry.getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException("Not a folder: " + path);
        }
        Type type = this.getRepository().getType(entry.getTypeId());
        return new APPFolder(entry, type);
    }

    @Override
    public List<Rendition> getRenditions(ObjectId object, Inclusion inclusion, Paging paging) {
        return Collections.emptyList();
    }

    @Override
    public boolean hasContentStream(ObjectId document) {
        APPObjectEntry current = this.getObjectEntry(document);
        ContentStream cs = current.getContentStream();
        if (cs == null) {
            return false;
        }
        if (cs != APPObjectEntry.REMOTE_CONTENT_STREAM) {
            return true;
        }
        String href = current.getContentHref();
        return href != null;
    }

    @Override
    public ContentStream getContentStream(ObjectId object, String contentStreamId) throws IOException {
        if (contentStreamId != null) {
            throw new UnsupportedOperationException("Cannot get non-default content stream: " + contentStreamId);
        }
        APPObjectEntry current = this.getObjectEntry(object);
        ContentStream cs = current.getContentStream();
        if (cs != APPObjectEntry.REMOTE_CONTENT_STREAM) {
            return cs;
        }
        String href = current.getContentHref();
        if (href == null) {
            throw new RuntimeException("Missing content src");
        }
        String mimeType = (String)((Object)current.getValue("cmis:contentStreamMimeType"));
        String filename = (String)((Object)current.getValue("cmis:contentStreamFileName"));
        cs = this.connector.getContentStream(href, mimeType, filename);
        return cs;
    }

    @Override
    public ObjectId setContentStream(ObjectId document, ContentStream cs, boolean overwrite) throws IOException {
        APPObjectEntry current = this.getObjectEntry(document);
        String href = current.getLink("edit-media");
        if (href == null) {
            throw new RuntimeException("Missing link edit-media");
        }
        this.connector.putStream(href, cs);
        return new SimpleObjectId(document.getId());
    }

    @Override
    public ObjectId deleteContentStream(ObjectId document) {
        APPObjectEntry current = this.getObjectEntry(document);
        String href = current.getLink("edit-media");
        if (href == null) {
            throw new RuntimeException("Missing link edit-media");
        }
        this.connector.delete(href, null, document.getId());
        return new SimpleObjectId(document.getId());
    }

    @Override
    public ObjectId updateProperties(ObjectId object, String changeToken, Map<String, Serializable> properties) {
        APPObjectEntry current = this.getObjectEntry(object);
        String href = current.getLink("edit");
        if (href == null) {
            throw new RuntimeException("Missing link edit");
        }
        APPObjectEntry update = this.newObjectEntry(current.getTypeId());
        for (String key : properties.keySet()) {
            update._setValue(key, properties.get(key));
        }
        update._setValue("cmis:objectId", (Serializable)((Object)object.getId()));
        update._setValue("cmis:name", current.getValue("cmis:name"));
        Header header = new Header("Content-Type", "application/atom+xml;type=entry");
        return this.connector.putEntry(href, header, update);
    }

    @Override
    public ObjectId moveObject(ObjectId object, ObjectId targetFolder, ObjectId sourceFolder) {
        APPObjectEntry entry = this.getObjectEntry(object);
        NameValuePairs params = new NameValuePairs();
        params.add("sourceFolderId", sourceFolder == null ? "" : sourceFolder.getId());
        return this.connector.postEntry(this.getPostHref(targetFolder), params, entry);
    }

    @Override
    public void deleteObject(ObjectId object, boolean allVersions) {
        APPObjectEntry current = this.getObjectEntry(object);
        String href = current.getLink("self");
        NameValuePairs params = new NameValuePairs();
        params.add("allVersions", String.valueOf(allVersions));
        this.connector.delete(href, params, object.getId());
    }

    @Override
    public Collection<ObjectId> deleteTree(ObjectId folder, Unfiling unfiling, boolean continueOnFailure) {
        APPObjectEntry current = this.getObjectEntry(folder);
        String href = current.getLink("down", "application/cmistree+xml");
        if (href == null) {
            throw new CMISRuntimeException("Missing link down application/cmistree+xml");
        }
        NameValuePairs params = new NameValuePairs();
        if (unfiling != null) {
            params.add("unfileObjects", unfiling.toString());
        }
        params.add("continueOnFailure", Boolean.toString(continueOnFailure));
        this.connector.delete(href, params, folder.getId());
        return Collections.emptyList();
    }

    @Override
    public void addObjectToFolder(ObjectId object, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeObjectFromFolder(ObjectId object, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListPage<ObjectEntry> query(String statement, boolean searchAllVersions, Inclusion inclusion, Paging paging) {
        String href = this.repository.getCollectionHref("query");
        if (href == null) {
            throw new CMISRuntimeException("Missing collection query");
        }
        return this.connector.postQuery(href, statement, searchAllVersions, inclusion, paging);
    }

    @Override
    public Collection<CMISObject> query(String statement, boolean searchAllVersions) {
        ListPage<ObjectEntry> res = this.query(statement, searchAllVersions, null, null);
        ArrayList<CMISObject> objects = new ArrayList<CMISObject>(res.size());
        for (ObjectEntry e : res) {
            objects.add(APPObject.construct((APPObjectEntry)e));
        }
        return objects;
    }

    @Override
    public ListPage<ObjectEntry> getChangeLog(String changeLogToken, boolean includeProperties, Paging paging, String[] latestChangeLogToken) {
        latestChangeLogToken[0] = null;
        return SimpleListPage.emptyList();
    }

    @Override
    public ObjectId checkOut(ObjectId document, boolean[] contentCopied) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelCheckOut(ObjectId document) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectId checkIn(ObjectId document, Map<String, Serializable> properties, ContentStream contentStream, boolean major, String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Serializable> getPropertiesOfLatestVersion(String versionSeriesId, boolean major, String filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ObjectEntry> getAllVersions(String versionSeriesId, String filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListPage<ObjectEntry> getRelationships(ObjectId object, String typeId, boolean includeSubRelationshipTypes, Inclusion inclusion, Paging paging) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyPolicy(ObjectId object, ObjectId policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePolicy(ObjectId object, ObjectId policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ObjectEntry> getAppliedPolicies(ObjectId object, String filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ACE> getACL(ObjectId object, boolean onlyBasicPermissions, boolean[] exact) {
        return Collections.emptyList();
    }

    @Override
    public List<ACE> applyACL(ObjectId object, List<ACE> addACEs, List<ACE> removeACEs, ACLPropagation propagation, boolean[] exact, String[] changeToken) {
        throw new UnsupportedOperationException();
    }
}

