/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.ChangeInfo;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Tree;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.ValueAdapter;
import org.apache.chemistry.atompub.client.APPConnection;
import org.apache.chemistry.atompub.client.APPRepository;
import org.apache.chemistry.atompub.client.stax.XmlProperty;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.xml.stax.XMLWriter;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPObjectEntry
implements ObjectEntry {
    protected static final ContentStream REMOTE_CONTENT_STREAM = new SimpleContentStream(new byte[0], null, null);
    protected final APPRepository repository;
    protected final APPConnection connection;
    protected final Map<String, XmlProperty> properties;
    protected ContentStream localContentStream = REMOTE_CONTENT_STREAM;
    protected Map<QName, Boolean> allowableActions;
    protected String remoteContentHref;
    protected String remoteContentType;
    protected final List<Link> links;
    protected String pathSegment;
    protected List<Tree<ObjectEntry>> children;

    protected APPObjectEntry(APPRepository repository, APPConnection connection, Map<String, XmlProperty> properties, Map<QName, Boolean> allowableActions) {
        this.repository = repository;
        this.connection = connection;
        this.properties = properties;
        allowableActions = allowableActions == null ? Collections.emptyMap() : Collections.unmodifiableMap(allowableActions);
        this.allowableActions = allowableActions;
        this.links = new ArrayList<Link>();
    }

    public APPObjectEntry(APPConnection connection, Map<String, XmlProperty> properties, Map<QName, Boolean> allowableActions) {
        this((APPRepository)connection.getRepository(), connection, properties, allowableActions);
    }

    public APPObjectEntry(APPRepository repository) {
        this(repository, null, new HashMap<String, XmlProperty>(), null);
    }

    public void addContentHref(String href, String type) {
        this.remoteContentHref = href;
        this.remoteContentType = type;
    }

    public String getContentHref() {
        return this.remoteContentHref;
    }

    public void addLink(String rel, String href, String type) {
        this.links.add(new Link(rel, href, type));
    }

    public Link[] getLinks() {
        return this.links.toArray(new Link[this.links.size()]);
    }

    public String getLink(String rel) {
        for (Link link : this.links) {
            if (!rel.equals(link.rel)) continue;
            return link.href;
        }
        return null;
    }

    public String getLink(String rel, String type) {
        String ctype = Link.canonicalType(type);
        for (Link link : this.links) {
            if (!rel.equals(link.rel) || !ctype.equals(link.type)) continue;
            return link.href;
        }
        return null;
    }

    public String getEditLink() {
        String href = this.getLink("edit");
        return href == null ? this.getLink("self") : href;
    }

    @Override
    public ChangeInfo getChangeInfo() {
        return null;
    }

    @Override
    public String getPathSegment() {
        return this.pathSegment;
    }

    protected boolean isCreation() {
        return this.getId() == null;
    }

    @Override
    public String getId() {
        return (String)((Object)this.getValue("cmis:objectId"));
    }

    @Override
    public String getTypeId() {
        return (String)((Object)this.getValue("cmis:objectTypeId"));
    }

    @Override
    public BaseType getBaseType() {
        return BaseType.get((String)((Object)this.getValue("cmis:baseTypeId")));
    }

    @Override
    public Serializable getValue(String id) {
        XmlProperty p = this.properties.get(id);
        return p == null ? null : p.getValue();
    }

    public XmlProperty getProperty(PropertyDefinition pd) {
        XmlProperty p = this.properties.get(pd.getId());
        if (p != null) {
            return p;
        }
        if (this.isCreation()) {
            p = new XmlProperty(pd);
            this.properties.put(pd.getId(), p);
        } else {
            p = new XmlProperty(pd);
            this.properties.put(pd.getId(), p);
        }
        return p;
    }

    @Override
    public Map<String, Serializable> getValues() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (Map.Entry<String, XmlProperty> e : this.properties.entrySet()) {
            String key;
            XmlProperty p = this.properties.get(key = e.getKey());
            map.put(key, p == null ? null : p.getValue());
        }
        return map;
    }

    @Override
    public void setValue(String id, Serializable value) {
        XmlProperty p = this.properties.get(id);
        if (p != null) {
            p.setValue(value);
        } else {
            PropertyDefinition pd = this.repository.getType(this.getTypeId()).getPropertyDefinition(id);
            if (pd == null) {
                throw new IllegalArgumentException("No such property: " + id);
            }
            p = new XmlProperty(pd);
            p.setValue(value);
            this.properties.put(id, p);
        }
    }

    protected void _setValue(String id, Serializable value) {
        XmlProperty p = this.properties.get(id);
        if (p != null) {
            p._setValue(value);
        } else {
            PropertyDefinition pd = this.repository.getType(this.getTypeId()).getPropertyDefinition(id);
            if (pd == null) {
                throw new IllegalArgumentException("No such property: " + id);
            }
            p = new XmlProperty(pd);
            p._setValue(value);
            this.properties.put(id, p);
        }
    }

    @Override
    public void setValues(Map<String, Serializable> values) {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    protected void setContentStream(ContentStream contentStream) {
        this.localContentStream = contentStream;
        this.setValue("cmis:contentStreamFileName", (Serializable)((Object)(contentStream == null ? null : contentStream.getFileName())));
    }

    protected ContentStream getContentStream() {
        return this.localContentStream;
    }

    @Override
    public Map<QName, Boolean> getAllowableActions() {
        return this.allowableActions;
    }

    @Override
    public Collection<ObjectEntry> getRelationships() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getTypeId() + ',' + this.getId() + ')';
    }

    public void writeContentTo(XMLWriter xw) throws IOException {
        if (this.localContentStream == null || this.localContentStream == REMOTE_CONTENT_STREAM) {
            xw.element("content").content("");
            return;
        }
        xw.element("content");
        String mimeType = this.localContentStream.getMimeType();
        if (mimeType.startsWith("text/")) {
            String text;
            String encoding = "UTF-8";
            if ((mimeType = mimeType.replace(" ", "")).indexOf(59) > 0) {
                String[] strings = mimeType.split(";");
                mimeType = strings[0];
                if (strings[1].startsWith("encoding=")) {
                    encoding = strings[1].substring("encoding=".length());
                }
            }
            if (mimeType.equals("text/plain")) {
                mimeType = "text";
            } else if (mimeType.equals("text/html")) {
                mimeType = "html";
            }
            xw.attr("type", (Object)mimeType);
            byte[] array = IOUtils.toByteArray(this.localContentStream.getStream());
            try {
                text = new String(array, encoding);
            }
            catch (UnsupportedEncodingException e) {
                text = new String(array, "ISO-8859-1");
            }
            xw.econtent(text);
        } else {
            xw.attr("type", (Object)mimeType);
            xw.contentBase64(this.localContentStream.getStream());
        }
    }

    public void writeObjectTo(XMLWriter xw) throws IOException {
        xw.element(AtomPubCMIS.OBJECT);
        xw.start();
        xw.element(CMIS.PROPERTIES);
        xw.start();
        for (XmlProperty p : this.properties.values()) {
            Object v;
            ValueAdapter va = p.getAdapter();
            xw.element(va.getPropertyQName()).attr(CMIS.PDID, (Object)p.getId());
            xw.start();
            if (p.isValueLoaded()) {
                v = p.getValue();
                if (v != null) {
                    if (v.getClass().isArray()) {
                        Serializable[] ar;
                        for (Serializable val : ar = (Serializable[])v) {
                            xw.element(CMIS.VALUE).content(va.writeValue(val));
                        }
                    } else {
                        xw.element(CMIS.VALUE).content(va.writeValue((Serializable)v));
                    }
                }
            } else {
                v = p.getXmlValue();
                if (v != null) {
                    if (v.getClass() == String.class) {
                        xw.element(CMIS.VALUE).content((String)v);
                    } else {
                        List list = (List)v;
                        for (String val : list) {
                            xw.element(CMIS.VALUE).content(val);
                        }
                    }
                }
            }
            xw.end();
        }
        xw.end();
        xw.end();
    }

    public static class Link {
        public final String rel;
        public final String href;
        public final String type;
        public static final Pattern TYPE_EQ = Pattern.compile("type=", 2);

        public Link(String rel, String href, String type) {
            this.rel = rel == null ? "" : rel;
            this.href = href;
            this.type = Link.canonicalType(type);
        }

        public static String canonicalType(String type) {
            if (type == null) {
                return null;
            }
            type = type.replace("\"", "");
            type = type.replace(" ", "");
            type = TYPE_EQ.matcher(type).replaceAll("type=");
            return type;
        }

        public String toString() {
            return "Link(" + this.rel + ',' + this.href + ',' + this.type + ')';
        }
    }
}

