/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.atompub.client.APPRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPType
extends APPObjectEntry
implements Type {
    private static final String UNDEFINED = "\u0000\u0000\u0000";
    protected Map<String, String> map;
    protected BaseType baseType;
    protected String parentId = "\u0000\u0000\u0000";
    protected Map<String, PropertyDefinition> propertyDefs;

    public APPType(APPRepository repository) {
        super(repository);
    }

    public void init(Map<String, String> properties, Map<String, PropertyDefinition> props) {
        if (this.map != null) {
            throw new IllegalStateException("Type is already intialized");
        }
        this.map = properties;
        this.propertyDefs = props;
    }

    @Override
    public String getDescription() {
        return this.map.get(CMIS.DESCRIPTION.getLocalPart());
    }

    @Override
    public String getDisplayName() {
        return this.map.get(CMIS.DISPLAY_NAME.getLocalPart());
    }

    @Override
    public String getId() {
        return this.getTypeId();
    }

    @Override
    public String getTypeId() {
        return this.map.get(CMIS.ID.getLocalPart());
    }

    @Override
    public BaseType getBaseType() {
        if (this.baseType == null) {
            this.baseType = BaseType.get(this.map.get(CMIS.BASE_ID.getLocalPart()));
        }
        return this.baseType;
    }

    public boolean isFolder() {
        return this.getBaseType() == BaseType.FOLDER;
    }

    @Override
    public String getParentId() {
        if (this.parentId == UNDEFINED) {
            this.parentId = this.map.get(CMIS.PARENT_ID.getLocalPart());
            if ("".equals(this.parentId)) {
                this.parentId = null;
            }
        }
        return this.parentId;
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String name) {
        this.loadPropertyDef();
        return this.propertyDefs.get(name);
    }

    @Override
    public Collection<PropertyDefinition> getPropertyDefinitions() {
        this.loadPropertyDef();
        return Collections.unmodifiableCollection(this.propertyDefs.values());
    }

    @Override
    public String getLocalName() {
        return this.map.get(CMIS.LOCAL_NAME.getLocalPart());
    }

    @Override
    public URI getLocalNamespace() {
        String uri = this.map.get(CMIS.LOCAL_NAMESPACE.getLocalPart());
        try {
            return uri == null ? null : new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getQueryName() {
        return this.map.get(CMIS.QUERY_NAME.getLocalPart());
    }

    @Override
    public boolean isControllablePolicy() {
        return "true".equals(this.map.get(CMIS.CONTROLLABLE_POLICY.getLocalPart()));
    }

    @Override
    public boolean isControllableACL() {
        return "true".equals(this.map.get(CMIS.CONTROLLABLE_ACL.getLocalPart()));
    }

    @Override
    public boolean isFulltextIndexed() {
        return "true".equals(this.map.get(CMIS.FULLTEXT_INDEXED.getLocalPart()));
    }

    @Override
    public boolean isCreatable() {
        return "true".equals(this.map.get(CMIS.CREATABLE.getLocalPart()));
    }

    @Override
    public boolean isFileable() {
        return "true".equals(this.map.get(CMIS.FILEABLE.getLocalPart()));
    }

    @Override
    public boolean isQueryable() {
        return "true".equals(this.map.get(CMIS.QUERYABLE.getLocalPart()));
    }

    @Override
    public boolean isVersionable() {
        return "true".equals(this.map.get(CMIS.VERSIONABLE.getLocalPart()));
    }

    @Override
    public ContentStreamPresence getContentStreamAllowed() {
        return ContentStreamPresence.get(this.map.get(CMIS.CONTENT_STREAM_ALLOWED), ContentStreamPresence.NOT_ALLOWED);
    }

    @Override
    public boolean isIncludedInSuperTypeQuery() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String[] getAllowedSourceTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String[] getAllowedTargetTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void loadPropertyDef() {
        if (this.propertyDefs == null) {
            String href = APPRepository.includePropertyDefinitionsInURI(this.getEditLink());
            APPType typeDef = this.repository.typesConnector.getType(href, true, this.getId());
            this.propertyDefs = typeDef.propertyDefs == null ? new HashMap() : typeDef.propertyDefs;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getId() + ')';
    }
}

