/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.stax.EntryReader;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntryReader<T>
implements EntryReader<T> {
    protected abstract T createObject(APPContext var1);

    @Override
    public T read(APPContext ctx, InputStream in) throws XMLStreamException {
        return this.read(ctx, StaxReader.newReader(in));
    }

    @Override
    public T read(APPContext ctx, XMLStreamReader reader) throws XMLStreamException {
        return this.read(ctx, StaxReader.newReader(reader));
    }

    @Override
    public T read(APPContext ctx, StaxReader reader) throws XMLStreamException {
        if (!reader.getFirstTag(AtomPub.ATOM_ENTRY)) {
            return null;
        }
        T object = this.createObject(ctx);
        ChildrenNavigator children = reader.getChildren();
        while (children.next()) {
            String nsuri = reader.getNamespaceURI();
            if (nsuri.equals("http://docs.oasis-open.org/ns/cmis/core/200908/") || nsuri.equals("http://docs.oasis-open.org/ns/cmis/restatom/200908/")) {
                this.readCmisElement(ctx, reader, object);
                continue;
            }
            this.readEntryElement(ctx, reader, object);
        }
        return object;
    }

    protected void readCmisElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
    }

    protected void readEntryElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        if (reader.getNamespaceURI().equals("http://www.w3.org/2005/Atom")) {
            this.readAtomElement(ctx, reader, object);
        } else {
            this.readExtensionElement(ctx, reader, object);
        }
    }

    protected void readAtomElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
    }

    protected void readExtensionElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
    }
}

