/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Tree;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPObjectFeedTreeReader;
import org.apache.chemistry.atompub.client.stax.AbstractEntryReader;
import org.apache.chemistry.atompub.client.stax.PropertyIterator;
import org.apache.chemistry.atompub.client.stax.XmlProperty;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.ParseException;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectReader<T>
extends AbstractEntryReader<T> {
    protected abstract void setProperty(T var1, XmlProperty var2);

    protected abstract void setAllowableActions(T var1, Map<QName, Boolean> var2);

    protected abstract void setPathSegment(T var1, String var2);

    protected abstract void setChildren(T var1, List<Tree<ObjectEntry>> var2);

    @Override
    protected void readCmisElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        QName name = reader.getName();
        if (AtomPubCMIS.OBJECT.equals(name)) {
            this.readCmisObject(ctx, reader, object);
        } else if (AtomPubCMIS.PATH_SEGMENT.equals(name)) {
            this.readPathSegment(ctx, reader, object);
        } else if (AtomPubCMIS.RELATIVE_PATH_SEGMENT.equals(name)) {
            this.readPathSegment(ctx, reader, object);
        } else if (AtomPubCMIS.CHILDREN.equals(name)) {
            this.readChildren(ctx, reader, object);
        }
    }

    protected void readCmisObject(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        ChildrenNavigator children = reader.getChildren();
        while (children.next()) {
            this.readObjectChildElement(ctx, reader, object);
        }
    }

    protected void readObjectChildElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        if (reader.getNamespaceURI().equals("http://docs.oasis-open.org/ns/cmis/core/200908/")) {
            QName name = reader.getName();
            if (CMIS.PROPERTIES.equals(name)) {
                this.readProperties(ctx, reader, object);
            } else if (CMIS.ALLOWABLE_ACTIONS.equals(name)) {
                this.readAllowableActions(ctx, reader, object);
            } else if (CMIS.CHANGE_EVENT_INFO.equals(name)) {
                this.readChangeEventInfo(ctx, reader, object);
            } else {
                this.readOtherCmisElement(ctx, reader, object);
            }
        } else {
            this.readEntryElement(ctx, reader, object);
        }
    }

    protected void readProperties(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        PropertyIterator it = new PropertyIterator(reader);
        while (it.hasNext()) {
            XmlProperty p = (XmlProperty)it.next();
            this.readPropertyWithType(ctx, reader, object, p);
        }
    }

    protected void readPropertyWithType(APPContext ctx, StaxReader reader, T object, XmlProperty p) {
        String id = p.getId();
        PropertyDefinition def = ctx.getRepository().getPropertyDefinition(id);
        if (def == null) {
            throw new ParseException("No such property definition: " + id);
        }
        p.setDefinition(def);
        this.setProperty(object, p);
    }

    protected void readAllowableActions(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        HashMap<QName, Boolean> allowableActions = new HashMap<QName, Boolean>();
        ChildrenNavigator children = reader.getChildren();
        while (children.next()) {
            QName qname = reader.getName();
            Boolean bool = Boolean.valueOf(reader.getElementText());
            allowableActions.put(qname, bool);
        }
        this.setAllowableActions(object, allowableActions);
    }

    protected void readChangeEventInfo(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
    }

    protected void readOtherCmisElement(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
    }

    protected void readPathSegment(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        this.setPathSegment(object, reader.getElementText());
    }

    protected void readChildren(APPContext ctx, StaxReader reader, T object) throws XMLStreamException {
        List list = (List)new APPObjectFeedTreeReader().read(ctx, reader);
        this.setChildren(object, list);
    }
}

