/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.io.IOException;
import java.util.Date;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.atompub.client.stax.AbstractXmlObjectWriter;
import org.apache.chemistry.xml.stax.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectEntryWriter
extends AbstractXmlObjectWriter<ObjectEntry> {
    @Override
    public String getContentType() {
        return "application/atom+xml;type=entry";
    }

    @Override
    public void write(ObjectEntry object, XMLWriter xw) throws IOException {
        try {
            xw.start();
            xw.element("entry");
            xw.xmlns("http://www.w3.org/2005/Atom");
            xw.xmlns("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
            xw.xmlns("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            xw.start();
            xw.element("id").content("urn:uuid:" + object.getId());
            String title = (String)((Object)object.getValue("cmis:name"));
            xw.element("title").content(title == null ? "" : title);
            xw.element("updated").content(new Date());
            this.writeContent(object, xw);
            this.writeCmisObject(object, xw);
            xw.end();
            xw.end();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            xw.close();
        }
    }

    protected abstract void writeContent(ObjectEntry var1, XMLWriter var2) throws IOException;

    protected abstract void writeCmisObject(ObjectEntry var1, XMLWriter var2) throws IOException;
}

