/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.atompub.client.stax.ValueIterator;
import org.apache.chemistry.atompub.client.stax.XmlProperty;
import org.apache.chemistry.xml.stax.ChildrenIterator;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyIterator
extends ChildrenIterator<XmlProperty> {
    public PropertyIterator(StaxReader sr) throws XMLStreamException {
        super(sr);
    }

    @Override
    protected boolean accept() {
        return this.reader.getNamespaceURI().equals("http://docs.oasis-open.org/ns/cmis/core/200908/") && this.reader.getLocalName().startsWith("property");
    }

    @Override
    protected XmlProperty getValue() throws XMLStreamException {
        String id = this.reader.getAttributeValue(CMIS.PDID);
        if (id == null) {
            throw new XMLStreamException("Parse error. Invalid CMIS property at line: " + this.reader.getLocation().getLineNumber() + ". No propertyDefinitionId specified");
        }
        ValueIterator vi = new ValueIterator(this.reader);
        if (!vi.hasNext()) {
            return new XmlProperty(id);
        }
        String val = (String)vi.next();
        if (!vi.hasNext()) {
            return new XmlProperty(id, val);
        }
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(val);
        do {
            vals.add((String)vi.next());
        } while (vi.hasNext());
        return new XmlProperty(id, vals);
    }
}

