/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.io.IOException;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.Paging;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.atompub.client.stax.AbstractXmlObjectWriter;
import org.apache.chemistry.xml.stax.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryWriter
extends AbstractXmlObjectWriter<String> {
    protected final boolean searchAllVersions;
    protected final Inclusion inclusion;
    protected final Paging paging;

    public QueryWriter(boolean searchAllVersions, Inclusion inclusion, Paging paging) {
        this.searchAllVersions = searchAllVersions;
        this.inclusion = inclusion;
        this.paging = paging;
    }

    @Override
    public String getContentType() {
        return "application/cmisquery+xml";
    }

    @Override
    public void write(String statement, XMLWriter xw) throws IOException {
        xw.start().putXmlns("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        xw.element(CMIS.QUERY);
        xw.start();
        xw.element(CMIS.STATEMENT).econtent(statement);
        xw.element(CMIS.SEARCH_ALL_VERSIONS).content(this.searchAllVersions);
        if (this.inclusion != null) {
            if (this.inclusion.renditions != null) {
                xw.element(CMIS.RENDITION_FILTER).econtent(this.inclusion.renditions);
            }
            if (this.inclusion.relationships != null) {
                xw.element(CMIS.INCLUDE_RELATIONSHIPS).content(RelationshipDirection.toInclusion(this.inclusion.relationships));
            }
            xw.element(CMIS.INCLUDE_ALLOWABLE_ACTIONS).content(this.inclusion.allowableActions);
            xw.element(CMIS.INCLUDE_POLICY_IDS).content(this.inclusion.policies);
            xw.element(CMIS.INCLUDE_ACL).content(this.inclusion.acls);
        }
        if (this.paging != null) {
            if (this.paging.maxItems > -1) {
                xw.element(CMIS.MAX_ITEMS).content(this.paging.maxItems);
            }
            xw.element(CMIS.SKIP_COUNT).content(this.paging.skipCount);
        }
        xw.end();
        xw.end();
    }
}

